/*************************************************************************************************/
/*!
   	@file		NormTableSinCfgView.h
	@author 	Fanzo
 	@date 		2008/6/8
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTableSinCfgView" class 
**************************************************************************************************/
class NormTableSinCfgView : public View
{
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	rControlMsg								m_msg;
	int										m_id;
	
	instance<NormFunctionSin>			m_norm;
	bool									m_tbl_i16_flag;
	instance<NormTable_i16>				m_tbl_i16;
	bool									m_tbl_f_flag;
	instance<NormTable_f>				m_tbl_f;

	const int								m_handle_r;
	const rgba								m_hc;
	
// private functions
private:
//=================================================================================================
fvector2 ToClient
		(
		const fvector2&		p
		)
{
	isize		size = GetRect().Size();
	return fvector2( p.x * ( size.width - m_handle_r * 2 ) + m_handle_r , size.height - ( p.y * ( size.height - m_handle_r * 2 ) + m_handle_r ) );
}
//=================================================================================================
float ToNormalized
		(
		float	y
		)
{
	isize	size	= GetRect().Size();
	int		l		= ( size.height - m_handle_r * 2 );
	float	v = ( y - m_handle_r ) / ( l == 0 ? 1 : l );
	v	= v < 0.0f ? 0.0f : ( v > 1.0f ? 1.0f : v );
	return 1.0f - v;
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawNormalizedBack( (iSurfaceDest)p->m_surface , GetRect().Size() , m_handle_r - 1 );
	
	fvector2		pnt[257];
	int				pntoff;
	for( pntoff = 0 ; pntoff < _countof( pnt ) ; pntoff++ )
	{
		pnt[pntoff] = ToClient( fvector2( ( pntoff / 256.0f ) , m_norm->GetNormalizedValue( pntoff / 256.0f ) ) );
	}
	DrawLine( (iSurfaceDest)p->m_surface , pnt , _countof( pnt ) , 1.0f , m_hc );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTableSinCfgView() : 
		m_handle_r( 4 ) , 
		m_id( 0 ) , 
		m_hc( 100 , 100 , 220 ) , 
		m_tbl_i16_flag( false ) , 
		m_tbl_f_flag( false )
{
	m_norm->SetCoefficient( 0.5f , 1.0f , 0.5f , 0.5f );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	set param
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetCoefficient
		(
		float	a , 
		float	b , 
		float	c , 
		float	d
		)
{
	m_norm->SetCoefficient( a , b , c , d );
	m_tbl_i16_flag	= false;
	m_tbl_f_flag	= false;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_i16 GetValue_i16()
{
	if( m_tbl_i16_flag == false )
	{
		m_tbl_i16->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_i16_flag	= true;
	}
	return (iNormTable_i16)m_tbl_i16;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue_f()
{
	if( m_tbl_f_flag == false )
	{
		m_tbl_f->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_f_flag	= true;
	}
	return (iNormTable_f)m_tbl_f;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace NormTableSinCfgView;		

#pragma pack( pop )			//release align
