/*************************************************************************************************/
/*!
   	@file		NormTableBicubicCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTableBicubicCfgView" class 
**************************************************************************************************/
class NormTableBicubicCfgView : public View
{
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	rControlMsg								m_msg;
	int										m_id;
	
	instance<NormFunctionBicubic>		m_norm;
	bool									m_tbl_f_flag;
	instance<NormTable_f>				m_tbl_f[2];

	const int								m_handle_r;
	const rgba								m_hc;
	
// private functions
private:
//=================================================================================================
fvector2 ToClient
		(
		const fvector2&		p
		)
{
	isize		size = GetRect().Size();
	return fvector2( p.x * ( size.width - m_handle_r * 2 ) / 2.0f + m_handle_r , size.height - ( ( p.y + 1.0f ) * ( size.height - m_handle_r * 2 ) / 2.0f + m_handle_r ) );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	DrawNormalizedBack( (iSurfaceDest)p->m_surface , GetRect().Size() , m_handle_r - 1 , true );
	
	fvector2		pnt[257];
	int				pntoff;
	for( pntoff = 0 ; pntoff < _countof( pnt ) ; pntoff++ )
	{
		pnt[pntoff] = ToClient( fvector2( ( 2.0f * pntoff / 256.0f ) , m_norm->GetNormalizedValue( 2.0f * pntoff / 256.0f ) ) );
	}
	DrawLine( (iSurfaceDest)p->m_surface , pnt , _countof( pnt ) , 1.0f , m_hc );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTableBicubicCfgView() : 
		m_handle_r( 4 ) , 
		m_id( 0 ) , 
		m_hc( 100 , 100 , 220 ) , 
		m_tbl_f_flag( false )
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue1_f()
{
	if( m_tbl_f_flag == false )
	{
		m_tbl_f[0]->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_f[1]->SetNormFunction( (iNormFunction)m_norm , 1.0f , 2.0f );
		m_tbl_f_flag	= true;
	}
	return (iNormTable_f)m_tbl_f[0];
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iNormTable_f GetValue2_f()
{
	if( m_tbl_f_flag == false )
	{
		m_tbl_f[0]->SetNormFunction( (iNormFunction)m_norm , 0.0f , 1.0f );
		m_tbl_f[1]->SetNormFunction( (iNormFunction)m_norm , 1.0f , 2.0f );
		m_tbl_f_flag	= true;
	}
	return (iNormTable_f)m_tbl_f[1];
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace NormTableBicubicCfgView;		

#pragma pack( pop )			//release align
