/*************************************************************************************************/
/*!
   	@file		JointCfgView.h
	@author 	Fanzo
 	@date 		2008/5/14
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"
#include	"RadioGroupView.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"JointCfgView" class 
**************************************************************************************************/
class JointCfgView : public RadioGroupView
{
// variable member
private:
	instance<JointBevel>		m_bevel;
	instance<JointMiter>		m_miter;
	instance<JointRound>		m_round;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
JointCfgView()
{
	SetRadioNum( 3 );
	SetString( 0 , L"bevel" );
	SetString( 1 , L"miter" );
	SetString( 2 , L"round" );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iJoint GetValue()
{
	int		s = GetSelect();
	if( s == 0 )
	{
		return ( iJoint )m_bevel;
	}
	else if( s == 1 )
	{
		return ( iJoint )m_miter;
	}
	else
	{
		return ( iJoint )m_round;
	}
}
};
/**************************************************************************************************
"JointCfgView_gp" class 
**************************************************************************************************/
class JointCfgView_gp : public RadioGroupView
{
// variable member
private:
	int							m_joint_id;
	iJoint						m_joint;
	
// private functions
private:
//=================================================================================================
void Update()
{
	int		s = GetSelect();
	if( m_joint == false || m_joint_id != s )
	{
		m_joint_id	= s;
		if( s == 0 )
			m_joint	= CreateJoint( Bevel_JointType_gp );
		else if( s == 1 )
			m_joint	= CreateJoint( Miter_JointType_gp );
		else
			m_joint	= CreateJoint( Round_JointType_gp );
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
JointCfgView_gp() : m_joint_id( 0 )
{
	SetRadioNum( 3 );
	SetString( 0 , L"bevel" );
	SetString( 1 , L"miter" );
	SetString( 2 , L"round" );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iJoint GetValue()
{
	Update();
	return m_joint;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace JointCfgView;		

#pragma pack( pop )			//release align
