/*************************************************************************************************/
/*!
   	@file		FillruleCfgView.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"FillruleCfgView" class 
**************************************************************************************************/
class FillruleCfgView : public View , public IRadioBoxMsg
{
	query_begin()
	iface_hook( IRadioBoxMsg , IRadioBoxMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioBox>				m_winding;
	instance<RadioBox>				m_even;

	PathFillRule						m_fillrule;

	rControlMsg							m_msg;
	int									m_id;

	const int							m_sh;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_radiobox
		(
		int		id
		)
{
	m_fillrule	= ( PathFillRule )( id - 100 );
	m_winding->SetValue( m_fillrule == Winding_PathFillRule ? true : false );
	m_even->SetValue( m_fillrule == EvenOdd_PathFillRule ? true : false );

	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	int		y = 0;
	m_winding->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , y ) , isize( p->m_rect.Size().width , m_sh ) )
			);
	m_winding->SetMsgCallback( ( rRadioBoxMsg )( reference )this_object() , 100 );
	m_winding->SetValue( m_fillrule == Winding_PathFillRule ? true : false );
	m_winding->SetString( L"winding" );
	y += m_sh;

	m_even->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , y ) , isize( p->m_rect.Size().width , m_sh ) )
			);
	m_even->SetMsgCallback( ( rRadioBoxMsg )( reference )this_object() , 101 );
	m_even->SetValue( m_fillrule == EvenOdd_PathFillRule ? true : false );
	m_even->SetString( L"even odd" );
	y += m_sh;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
FillruleCfgView() :
		m_sh( 15 ) , 
		m_fillrule( Winding_PathFillRule ) , 
		m_id( 0 ) 
{
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
PathFillRule GetValue()
{
	return m_fillrule;
}

};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace FillruleCfgView;		

#pragma pack( pop )			//release align
