/*************************************************************************************************/
/*!
   	@file		ColorCfgView.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"ColorCfgView" class 
**************************************************************************************************/
class ColorCfgView : public View , public ISliderMsg
{
	query_begin()
	iface_hook( ISliderMsg , ISliderMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	instance<Slider>					m_r;
	instance<Slider>					m_g;
	instance<Slider>					m_b;
	instance<Slider>					m_a;
	rgba								m_color;
	instance<Font>					m_font;
	
	rControlMsg							m_msg;
	int									m_id;
	
	const int							m_round;
	const int							m_sh;
	const int							m_info_w;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_slider
		(
		int		id
		)
{
	if( id == 100 )
		m_color.r = ( int )( m_r->GetValue() * 255 );
	else if( id == 101 )
		m_color.g = ( int )( m_g->GetValue() * 255 );
	else if( id == 102 )
		m_color.b = ( int )( m_b->GetValue() * 255 );
	else if( id == 103 )
		m_color.a = ( int )( m_a->GetValue() * 255 );
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );

	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_r->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_round , m_round ) , isize( p->m_rect.Size().width - m_round * 2 - m_info_w , m_sh ) )
			);
	m_r->SetValue( ( float )m_color.r / 255.0f );
	m_r->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 );
	m_g->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_round , m_round + m_sh ) , isize( p->m_rect.Size().width - m_round * 2 - m_info_w , m_sh ) )
			);
	m_g->SetValue( ( float )m_color.g / 255.0f );
	m_g->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 101 );
	m_b->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_round , m_round + m_sh*2 ) , isize( p->m_rect.Size().width - m_round * 2 - m_info_w , m_sh ) )
			);
	m_b->SetValue( ( float )m_color.b / 255.0f );
	m_b->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 102 );
	m_a->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( m_round , m_round + m_sh*3 ) , isize( p->m_rect.Size().width - m_round * 2 - m_info_w , m_sh ) )
			);
	m_a->SetValue( ( float )m_color.a / 255.0f );
	m_a->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 103 );
	
//	SetValue( rgba( 127 , 191 , 121 , 255 ) );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	wchar_t	text[ 256 ];
	cb_swprintf( text , L"R:%d" , m_color.r );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_round - m_info_w ) , ( float )( m_round + m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	cb_swprintf( text , L"G:%d" , m_color.g );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_round - m_info_w ) , ( float )( m_round + m_sh * 1 + m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	cb_swprintf( text , L"B:%d" , m_color.b );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_round - m_info_w ) , ( float )( m_round + m_sh * 2 + m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	cb_swprintf( text , L"A:%d" , m_color.a );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( ( float )( GetRect().Size().width - m_round - m_info_w ) , ( float )( m_round + m_sh * 3 + m_sh / 2 ) ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ColorCfgView() : m_round( 0 ) , m_sh( 15 ) , m_info_w( 30 ) , m_id( 0 )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	SetValue
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetValue
		(
		const rgba&		color
		)
{
	m_color	= color;
	m_r->SetValue( ( float )m_color.r / 255.0f );
	m_g->SetValue( ( float )m_color.g / 255.0f );
	m_b->SetValue( ( float )m_color.b / 255.0f );
	m_a->SetValue( ( float )m_color.a / 255.0f );
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
rgba GetValue()
{
	return m_color;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace ColorCfg;		

#pragma pack( pop )			//release align
