/*************************************************************************************************/
/*!
   	@file		BrushSurfaceCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BrushSurfaceCfgView" class 
**************************************************************************************************/
class BrushSurfaceCfgView : public View , public IControlMsg
{
	query_begin()
	iface_hook( IControlMsg , IControlMsg_IID )	
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_map_end( View )

// variable member
private:
	instance<RadioGroupView>					m_select;
	instance<TextureCfgView>					m_texture;
	instance<WrapTypeCfgView>				m_wraptype;
	iPaintImage_gp								m_brush;
	
	rControlMsg									m_msg;
	int											m_id;
	
	
	// edit data
	fvector2			m_pos;
	fvector2			m_zoom;
	float				m_rotate;

	iPen_gp				m_pen_handle;
	iPaint_gp			m_brush_handle;
	const float			m_coor_l;
	const float			m_handle_r;
	const int			m_info_w;
	const int			m_sh;
	const int			m_item_h;

// private functions
private:	
//=================================================================================================
void UpdateBrush()
{
	int		sel = m_select->GetSelect();
	SourceInterpolateType_gp	interpolate;
	if( sel == 0 )
		interpolate = Nearest_SourceInterpolateType_gp;
	else if( sel == 1 )
		interpolate = Linear_SourceInterpolateType_gp;
	else
		interpolate = Bicubic_SourceInterpolateType_gp;
	m_brush		= CreatePaintImage((iSurfaceSource)m_texture->GetValue() , interpolate );
}	
// "IControlMsg" msg	
//=================================================================================================
void cb_call ValueChanged_controlmsg
		(
		int		id
		)
{
	if( id == 1 )
		UpdateBrush();
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}
// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_select->SetAlign( Horz_RadioAlign );
	m_select->SetRadioNum( 3 );
	m_select->SetString( 0 , L"nearest" );
	m_select->SetString( 1 , L"linear" );
	m_select->SetString( 2 , L"bicubic" );
	m_select->SetSelect( 0 );
	m_select->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width , m_item_h ) )
			);
	m_select->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );
	m_texture->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_item_h ) , isize( m_info_w , m_sh ) )
			);
	m_texture->SetMsgCallback( ( rControlMsg )( reference )this_object() , 1 );

	m_wraptype->SetAlign( Horz_RadioAlign );
	m_wraptype->Create
			(
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh + m_item_h ) , isize( m_info_w , m_sh ) )
			);
	m_wraptype->SetMsgCallback( ( rControlMsg )( reference )this_object() , 0 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BrushSurfaceCfgView() : 
		m_id( 0 ) , 
		m_item_h( 20 ) , 
		m_info_w( 200 ) , 
		m_pos( 0.0f , 0.0f ) , 
		m_zoom( 1.0f , 1.0f ) , 
		m_rotate( 0.0f ) , 
		m_coor_l( 20.0f ) , 
		m_handle_r( 1.0f ) , 
		m_sh( 15 )
{
	m_pen_handle	= CreatePenStroke();
	m_brush_handle	= CreatePaintSolid( rgba( 40 , 121 , 121 , 255 ) );
}		
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	add texture
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddTexture
		(
		const wstring&	path
		)
{
	return m_texture->AddTexture( path );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iPaint_gp GetBrush
		(
		const DPI&		dpi , 
		const faffine&	ltod
		)
{
	if( m_brush == false )
		UpdateBrush();
	m_brush->SetWraptype( m_wraptype->GetValue() );
	faffine		taff	= faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate ) * faffine::GetScale( m_zoom.x , m_zoom.y );
	DPI			sdpi	= m_texture->GetValue()->GetDestDPI();
	taff = sdpi.DtoD_xy( dpi ).Inverse() * taff.Inverse() * ltod.Inverse();
	m_brush->SetTransform( taff );
	return (iPaint_gp)m_brush;
}
//=================================================================================================
int GetEditPointNum()
{
	return 4;
}
//=================================================================================================
fvector2 GetEditPoint
		(
		int				off
		)
{
	faffine		aff	= faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate ) * faffine::GetScale( m_zoom.x , m_zoom.y );
	if( off == 0 )
		return aff.Transform( fvector2( 0.0f , 0.0f ) );
	else if( off == 1 )
		return aff.Transform( fvector2( m_coor_l , 0.0f ) );
	else if( off == 2 )
		return aff.Transform( fvector2( 0.0f , m_coor_l ) );
	else
	{
		faffine		taff	= faffine::GetMove( m_pos ) * faffine::GetRotate( m_rotate );
		return taff.Transform( fvector2( m_coor_l , m_coor_l ) );
	}
}
//=================================================================================================
void SetEditPoint
		(
		int				off , 
		fvector2		pnt
		)
{
	if( off == 0 )
		m_pos = pnt;
	else if( off == 1 )
	{
		fvector2	v = pnt - m_pos;
		fvector2	b = faffine::GetRotate( m_rotate ).Transform( fvector2( 1.0f , 0.0f ) ).GetUnit();
		m_zoom.x	= v.Inner( b ) / m_coor_l;
	}
	else if( off == 2 )
	{
		fvector2	v = pnt - m_pos;
		fvector2	b = faffine::GetRotate( m_rotate ).Transform( fvector2( 0.0f , 1.0f ) ).GetUnit();
		m_zoom.y	= v.Inner( b ) / m_coor_l;
	}
	else if( off == 3 )
	{
		fvector2	v = pnt - m_pos;
		m_rotate	= v.GetAngle_f( fvector2( 1.0f , 1.0f ) );
	}
}	
//=================================================================================================
bool SearchEditPoint
		(
		const fvector2&		pnt , 
		int*				pntoff
		)
{
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
	{
		fvector2	p = GetEditPoint( off );
		frect		r( p.x - m_handle_r , p.y - m_handle_r , p.x + m_handle_r , p.y + m_handle_r );
		if( true == r.IsInside( pnt ) )
		{
			*pntoff	= off;
			return true;
		}
	}
	return false;
}
//=================================================================================================
void DrawEditHandle
		(
		iGraphics_gp&	g , 
		const faffine&	ltod
		)
{
	g->SetStrokeWidth( 0.5f );
	g->SetStrokePen( m_pen_handle );
	g->SetStrokePaint( m_brush_handle );
	g->SetPaint( m_brush_handle );
	fvector2	pnt1[] = { GetEditPoint( 0 ) , GetEditPoint( 1 ) };
	fvector2	pnt2[] = { GetEditPoint( 0 ) , GetEditPoint( 2 ) };
	g->StrokeLine( _countof( pnt1 ) , pnt1 , faffine() , ltod );
	g->StrokeLine( _countof( pnt2 ) , pnt2 , faffine() , ltod );
	int		off , num = GetEditPointNum();
	for( off = 0 ; off < num ; off++ )
		g->PaintCircle( GetEditPoint( off ) , m_handle_r , m_handle_r , ltod );
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
