/*************************************************************************************************/
/*!
   	@file		BlenderCfgView.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"BlenderCfgView" class 
**************************************************************************************************/
class BlenderCfgView : public RadioGroupView
{
// variable member
private:
	instance<BlenderOverlap>		m_overlap;
	instance<BlenderOnezero>		m_onezero;
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BlenderCfgView()
{
	SetRadioNum( 2 );
	SetString( 0 , L"overlap" );
	SetString( 1 , L"onezero" );
	SetAlign( Horz_RadioAlign );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iBlender GetValue()
{
	if( GetSelect() == 0 )
		return (iBlender)m_overlap;
	else
		return (iBlender)m_onezero;
}
};

/**************************************************************************************************
"BlenderCfgView_gp" class 
**************************************************************************************************/
class BlenderCfgView_gp : public RadioGroupView
{
// variable member
private:
	int				m_blender_id;
	iBlender		m_blender;
	
// private functions
private:
//=================================================================================================
void Update()
{
	int		s = GetSelect();
	if( m_blender == false || m_blender_id != s )
	{
		m_blender_id	= s;
		if( s == 0 )
			m_blender	= CreateBlender( Overlap_BlenderType_gp );
		else
			m_blender	= CreateBlender( Onezero_BlenderType_gp );
	}
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BlenderCfgView_gp() : m_blender_id( 0 )
{
	SetRadioNum( 2 );
	SetString( 0 , L"overlap" );
	SetString( 1 , L"onezero" );
	SetAlign( Horz_RadioAlign );
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iBlender GetBlender()
{
	Update();
	return m_blender;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace BlenderCfgView;		

#pragma pack( pop )			//release align
