/*************************************************************************************************/
/*!
   	@file		AffineCfgView.h
	@author 	Fanzo
 	@date 		2008/5/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iControlMsg.h"

#pragma pack( push , 8 )		//set align

namespace shared
{
using namespace icubic;
///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"AffineCfgView" class 
**************************************************************************************************/
class AffineCfgView : public View , public ISliderMsg
{
	query_begin()
	iface_hook( ISliderMsg , ISliderMsg_IID )
	query_end( View )
	
	msg_view_map_begin()
	msg_view_hook( Create , OnCreate )
	msg_view_hook( Update , OnUpdate )
	msg_view_map_end( View )

// variable member
private:
	instance<Slider>					m_x;
	instance<Slider>					m_y;
	instance<Slider>					m_r;
	instance<Slider>					m_zx;
	instance<Slider>					m_zy;

	rControlMsg							m_msg;
	int									m_id;
	
	instance<Font>					m_font;
	const float							m_rate_xy;
	const float							m_rate_r;
	const float							m_rate_zxy;
	const int							m_sh;
	const int							m_info_w;
	
// ctrlmsg functions
private:
//=================================================================================================
//!	Slider
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call ValueChanged_slider
		(
		int		id
		)
{
	RequireUpdate( irect( ivector2( 0 , 0 ) , GetRect().Size() ) , false );
	iControlMsg	ck = m_msg.lock();
	if( ck == true )
		ck->ValueChanged_controlmsg( m_id );
}

// msg functions
protected:
//=================================================================================================
void OnCreate
		(
		Create_ViewPM*	p
		)
{
	m_x->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , 0 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_x->SetValue( 0.5f );
	m_x->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 100 );
	
	m_y->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_y->SetValue( 0.5f );
	m_y->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 101 );

	m_r->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh * 2 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_r->SetValue( 0.5f );
	m_r->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 102 );

	m_zx->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh * 3 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_zx->SetValue( 1.0f / m_rate_zxy + 0.5f );
	m_zx->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 103 );

	m_zy->Create
			( 
			( rViewParentCtrl )( reference )this_object() , 
			irect( ivector2( 0 , m_sh * 4 ) , isize( p->m_rect.Size().width - m_info_w , m_sh ) )
			);
	m_zy->SetValue( 1.0f / m_rate_zxy + 0.5f );
	m_zy->SetMsgCallback( ( rSliderMsg )( reference )this_object() , 103 );
}
//=================================================================================================
void OnUpdate
		(
		Update_ViewPM*	p
		)
{
	wchar_t	text[ 256 ];
	float		x = ( float )( GetRect().Size().width - m_info_w );
	float		y = ( float )( m_sh / 2 );
	cb_swprintf( text , L"x:%.2f" , ( m_x->GetValue() - 0.5f ) * m_rate_xy );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	y += ( float )m_sh;
	cb_swprintf( text , L"y:%.2f" , ( m_y->GetValue() - 0.5f ) * m_rate_xy );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	y += ( float )m_sh;
	cb_swprintf( text , L"r:%.2f" , 180.0f * ( m_r->GetValue() - 0.5f ) * m_rate_r / PI_f );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	y += ( float )m_sh;
	cb_swprintf( text , L"zx:%.2f" , ( m_zx->GetValue() - 0.5f ) * m_rate_zxy );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	y += ( float )m_sh;
	cb_swprintf( text , L"zy:%.2f" , ( m_zy->GetValue() - 0.5f ) * m_rate_zxy );
	DrawText( (iSurfaceDest)p->m_surface , fvector2( x , y ) , text , ( iFont )m_font , rgb(0,0,0) , Center_TextAlign );
	y += ( float )m_sh;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
AffineCfgView() :
		m_sh( 15 ) , 
		m_info_w( 40 ) , 
		m_rate_xy( 500.0f ) , 
		m_rate_r( PI_2_f * 3.0f ) , 
		m_rate_zxy( 10.0f ) , 
		m_id( 0 )
{
	cb_verify( true == m_font->Create( fsize( 0.0f , 10.0f ) , L"Tahoma" , Roman_FontCharsetType , 400 , false ) );
}
//=================================================================================================
//!	set msg
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void SetMsgCallback
		(
		rControlMsg&		msg , 
		int					id
		)
{
	m_msg	= msg;
	m_id	= id;
}
//=================================================================================================
//!	get value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
faffine GetValue()
{
	faffine		m = faffine::GetMove( fvector2( ( m_x->GetValue() - 0.5f ) * m_rate_xy , ( m_y->GetValue() - 0.5f ) * m_rate_xy ) );
	faffine		r = faffine::GetRotate( ( m_r->GetValue() - 0.5f ) * m_rate_r );
	faffine		z = faffine::GetScale( ( m_zx->GetValue() - 0.5f ) * m_rate_zxy , ( m_zy->GetValue() - 0.5f ) * m_rate_zxy );
	
	return m * r * z;
}

};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace AffineCfgView;		

#pragma pack( pop )			//release align
