/*************************************************************************************************/
/*!
   	@file		iMemAllocator.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IMemAllocator" interface 
***************************************************************************************************/
cb_guid_define( IMemAllocator_IID , 0xB5407790 , 0x7980415b , 0xA94D5879 , 0x6232F518 );
class IMemAllocator;
typedef icubic::iface_object< IMemAllocator , IMemAllocator_IID >		iMemAllocator;
typedef icubic::iface_reference< IMemAllocator , IMemAllocator_IID >	rMemAllocator;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IMemAllocator
{
public:
//=================================================================================================
//!	allocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call Allocate
		(
		uint32		size
		) = 0;
//=================================================================================================
//!	deallocate
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Deallocate
		(
		void*	p
		) = 0;
//=================================================================================================
//!	deallocate all
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call DeallocateAll() = 0;
};



///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
