/*************************************************************************************************/
/*!
   	@file		pp_cpp_gradation_linear.h
	@author 	Fanzo
 	@date 		2008/4/20
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{
//=================================================================================================
// gradation linear w
//=================================================================================================
cb_inline
void pp_gradation_linear_wrgb
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		uint16			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.wrgb.r	= ( sc.wrgb.r * d + tc.wrgb.r * ( 256 - d ) ) >> 8;
	r.wrgb.g	= ( sc.wrgb.g * d + tc.wrgb.g * ( 256 - d ) ) >> 8;
	r.wrgb.b	= ( sc.wrgb.b * d + tc.wrgb.b * ( 256 - d ) ) >> 8;
	*store	= r;
}
//=================================================================================================
cb_inline
void pp_gradation_linear_wrgba
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		uint16			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.wrgba.a	= ( sc.wrgba.a * d + tc.wrgba.a * ( 256 - d ) ) >> 8;
	r.wrgba.r	= ( sc.wrgba.r * d + tc.wrgba.r * ( 256 - d ) ) >> 8;
	r.wrgba.g	= ( sc.wrgba.g * d + tc.wrgba.g * ( 256 - d ) ) >> 8;
	r.wrgba.b	= ( sc.wrgba.b * d + tc.wrgba.b * ( 256 - d ) ) >> 8;
	*store	= r;
}
//=================================================================================================
cb_inline
void pp_gradation_linear_wa
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		uint16			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.wa.a	= ( sc.wa.a * d + tc.wa.a * ( 256 - d ) ) >> 8;
	*store	= r;
}
//=================================================================================================
// gradation linear f
//=================================================================================================
cb_inline
void pp_gradation_linear_frgb
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		float			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.frgb.r	= ( sc.frgb.r * d + tc.frgb.r * ( 1.0f - d ) );
	r.frgb.g	= ( sc.frgb.g * d + tc.frgb.g * ( 1.0f - d ) );
	r.frgb.b	= ( sc.frgb.b * d + tc.frgb.b * ( 1.0f - d ) );
	*store	= r;
}
//=================================================================================================
cb_inline
void pp_gradation_linear_frgba
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		float			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.frgba.a	= ( sc.frgba.a * d + tc.frgba.a * ( 1.0f - d ) );
	r.frgba.r	= ( sc.frgba.r * d + tc.frgba.r * ( 1.0f - d ) );
	r.frgba.g	= ( sc.frgba.g * d + tc.frgba.g * ( 1.0f - d ) );
	r.frgba.b	= ( sc.frgba.b * d + tc.frgba.b * ( 1.0f - d ) );
	*store	= r;
}
//=================================================================================================
cb_inline
void pp_gradation_linear_fa
		(
		pp_pixel_calc	*store , 
		pp_pixel_calc	&sc , 
		pp_pixel_calc	&tc , 
		float			d
		)
{
	pp_pixel_calc	r;
	
	// c' = ( sc * d + tc * ( 256-d ) ) / 256
	r.fa.a	= ( sc.fa.a * d + tc.fa.a * ( 1.0f - d ) );
	*store	= r;
}
//=================================================================================================
// gradation linear
//=================================================================================================

//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_int16_rgb
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_wrgba( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_wrgba( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		int16		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_wrgba( &c , sc , tc , d );
		
		wrgba_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		dest	= AddPixelSize_rgb( dest );
		tbl_off	+= tbl_def;
	}
}
//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_int16_rgba
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_wrgba( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_wrgba( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		int16		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_wrgba( &c , sc , tc , d );
		
		wrgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		dest	= AddPixelSize_rgba( dest );
		tbl_off	+= tbl_def;
	}
}
//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_int16_a
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_wa( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_wa( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		int16		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_wa( &c , sc , tc , d );
		
		wa_to_a( &c , c );
		StoreAddr_a( dest , c );
		dest	= AddPixelSize_a( dest );
		tbl_off	+= tbl_def;
	}
}

//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_float_rgb
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_frgba( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_frgba( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		float		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_frgba( &c , sc , tc , d );
		
		frgba_to_rgb( &c , c );
		StoreAddr_rgb( dest , c );
		dest	= AddPixelSize_rgb( dest );
		tbl_off	+= tbl_def;
	}
}
//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_float_rgba
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_frgba( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_frgba( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		float		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_frgba( &c , sc , tc , d );
		
		frgba_to_rgba( &c , c );
		StoreAddr_rgba( dest , c );
		dest	= AddPixelSize_rgba( dest );
		tbl_off	+= tbl_def;
	}
}
//=================================================================================================
cb_inline
void pp_cpp_gradation_linear_float_a
		(
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	// def tbloff
	int32	ist	= ( int32 )( st * ( 256 << 16 ) );
	int32	itt	= ( int32 )( tt * ( 256 << 16 ) );
	ist	= ist < 0 ? 0 : ( ist >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : ist );
	itt	= itt < 0 ? 0 : ( itt >= ( ( 256 << 16 ) + 0xFFFF ) ? ( ( 256 << 16 ) + 0xFFFF ) : itt );
		
	int32	tbl_def	= ( itt - ist ) / ( len == 1 ? 1 : (len-1) );
	int32	tbl_off	= ist;

	// ss_color , st_color
	pp_pixel_calc	sc;
	color_to_fa( &sc , ss_color );
	pp_pixel_calc	tc;
	color_to_fa( &tc , st_color );
	
	// render
	int		off;
	for( off = 0 ; off < len ; off++ )
	{
		float		d = blendtbl[ tbl_off >> 16 ];
		pp_pixel_calc	c;
		pp_gradation_linear_fa( &c , sc , tc , d );
		
		fa_to_a( &c , c );
		StoreAddr_a( dest , c );
		dest	= AddPixelSize_a( dest );
		tbl_off	+= tbl_def;
	}
}

//=================================================================================================
//!	gradation linear
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_gradation_linear_i16
		(
		pp_format		destformat , 
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const int16*	blendtbl
		)
{
	typedef void (*func)( void* , int32 , const pp_color& , const pp_color& , float , float , const int16* );

	static
	func	funclist[4] = 
	{	
	pp_cpp_gradation_linear_int16_rgb , 
	pp_cpp_gradation_linear_int16_rgba , 
	pp_cpp_gradation_linear_int16_a , 
	};
	( funclist[ destformat ] )( dest , len , ss_color , st_color , st , tt , blendtbl );
}

//=================================================================================================
//!	gradation linear
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void pp_cpp_gradation_linear_f
		(
		pp_format		destformat , 
		void			*dest , 
		int32			len , 
		const pp_color&	ss_color , 
		const pp_color&	st_color , 
		float			st , 
		float			tt , 
		const float*	blendtbl
		)
{
	typedef void (*func)( void* , int32 , const pp_color& , const pp_color& , float , float , const float* );

	static
	func	funclist[4] = 
	{	
	pp_cpp_gradation_linear_float_rgb , 
	pp_cpp_gradation_linear_float_rgba , 
	pp_cpp_gradation_linear_float_a , 
	};
	( funclist[ destformat ] )( dest , len , ss_color , st_color , st , tt , blendtbl );
}


};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align

