/*************************************************************************************************/
/*!
   	@file		iPathToOutline.h
	@author 	Fanzo
 	@date 		2008/5/8
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutline.h"
#include	"iFace/iPath.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IPathToOutline" interface 
***************************************************************************************************/
cb_guid_define( IPathToOutline_IID , 0xAB5EC66F , 0x7A7840be , 0xBE435601 , 0xFF33832C );
class IPathToOutline;
typedef icubic::iface_object< IPathToOutline , IPathToOutline_IID >		iPathToOutline;
typedef icubic::iface_reference< IPathToOutline , IPathToOutline_IID >	rPathToOutline;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathToOutline
{
public:
//=================================================================================================
//!	generate outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ToOutline
		(
		iOutline&		outline , 
		const PathInfo&	pathinfo , 
		iOutlineGen&	gen , 
		const faffine&	aff
		) = 0;
};
/**************************************************************************************************
 "IPathSegmentToOutline" interface 
***************************************************************************************************/
cb_guid_define( IPathSegmentToOutline_IID , 0x46C8D569 , 0xFD664822 , 0xBB1C4DF5 , 0x06C53A90 );
class IPathSegmentToOutline;
typedef icubic::iface_object< IPathSegmentToOutline , IPathSegmentToOutline_IID >	iPathSegmentToOutline;
typedef icubic::iface_reference< IPathSegmentToOutline , IPathSegmentToOutline_IID >	rPathSegmentToOutline;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathSegmentToOutline : public IPathTo
{
public:
//=================================================================================================
//!	begin
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Begin
		(
		iOutline&		outline , 
		iOutlineGen&	gen
		) = 0;
//=================================================================================================
//!	custom path
//!	@retval			---
//-------------------------------------------------------------------------------------------------
/*
virtual
void cb_call CustomPath
		(
		iPathSegment&	ps		//!< [in] it need to effect affine.
		) = 0;
*/
//=================================================================================================
//!	end
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
fvector2 cb_call End() = 0;
};
/**************************************************************************************************
 "IPathToEdgemap" interface 
***************************************************************************************************/
cb_guid_define( IPathToEdgemap_IID , 0xE8BA709C , 0xEF834228 , 0xBC7B09BA , 0xF61E6C0E );
class IPathToEdgemap;
typedef icubic::iface_object< IPathToEdgemap , IPathToEdgemap_IID >		iPathToEdgemap;
typedef icubic::iface_reference< IPathToEdgemap , IPathToEdgemap_IID >	rPathToEdgemap;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IPathToEdgemap
{
public:
//=================================================================================================
//!	to edgemap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ToEdgemap
		(
		IEdgemapOutline*	edgemap , 
		IPathLogicInfo*		path , 			//!< [in]  convert path
		const faffine&		affine , 		//!< [in]  convert affine
		iOutlineGen&		gen ,  			//!< [in]  outline gen
		PathFillRule		rule ,
		const faffine&		ltod ,			//!< [in]  logical to device
		const irect&		area , 
		antialias			anti , 
		frect*				boundbox = 0
		) = 0;
//=================================================================================================
//!	to edgemap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ToEdgemap
		(
		IEdgemapOutline*	edgemap , 
		IPathLogicInfo*		path ,
		const faffine&		path_affine ,
		iOutlineGen&		path_gen ,
		PathFillRule		path_rule ,
		IPathLogicInfo*		clip_path ,
		const faffine&		clip_affine ,
		iOutlineGen&		clip_gen ,
		PathFillRule		clip_rule ,
		const faffine&		ltod , 
		const irect&		area , 
		antialias			anti , 
		frect*				boundbox = 0
		) = 0;
};
/**************************************************************************************************
 "IOutlineToOutline" interface 
***************************************************************************************************/
cb_guid_define( IOutlineToOutline_IID , 0xB02F875B , 0x6C564a0d , 0xB3436425 , 0x32F371EB );
class IOutlineToOutline;
typedef icubic::iface_object< IOutlineToOutline , IOutlineToOutline_IID >		iOutlineToOutline;
typedef icubic::iface_reference< IOutlineToOutline , IOutlineToOutline_IID >	rOutlineToOutline;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IOutlineToOutline
{
public:
//=================================================================================================
//!	Outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ToOutline
		(
		iOutline&		out_outline , 	//!< [mod] output outline
		iOutline&		in_outline , 	//!< [in] input outline
		const faffine&	affine , 
		iOutlineGen&	gen
		) = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
