/*************************************************************************************************/
/*!
   	@file		GraphicsCmds.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IGraphicsAttrCmd" interface 
***************************************************************************************************/
cb_guid_define( IGraphicsAttrCmd_IID , 0x43D02512 , 0x3F654db0 , 0xB133654F , 0xAF2A0EAC );
class IGraphicsAttrCmd;
typedef icubic::iface_object< IGraphicsAttrCmd , IGraphicsAttrCmd_IID >		iGraphicsAttrCmd;
typedef icubic::iface_reference< IGraphicsAttrCmd , IGraphicsAttrCmd_IID >	rGraphicsAttrCmd;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphicsAttrCmd
{
public:
//=================================================================================================
//!	push attr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call PushAttr() = 0;
//=================================================================================================
//!	pop attr
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call PopAttr() = 0;
//=================================================================================================
//!	get antialias
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
antialias cb_call GetAntialias() = 0;
//=================================================================================================
//!	set antialias
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetAntialias
		(
		antialias	anti
		) = 0;
//=================================================================================================
//!	get surface
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iSurfaceDest cb_call GetSurface() = 0;
//=================================================================================================
//!	get coord
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
Coord_view cb_call GetCoord() = 0;
//=================================================================================================
//!	set coord
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetCoord
		(
		const faffine&		vtod , 
		const DPI&			dpi , 
		const frect&		view
		) = 0;
//=================================================================================================
//!	get transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
faffine cb_call GetTransform() = 0;
//=================================================================================================
//!	set transform
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetTransform
		(
		const faffine&	trans
		) = 0;
//=================================================================================================
//!	set clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetClip
		(
		IPathLogicInfo*	clip , 
		const faffine&	transform
		) = 0;
//=================================================================================================
//!	release clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseClip() = 0;
//=================================================================================================
//!	get clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iEdgemapOutline GetClip() = 0;
};
/**************************************************************************************************
 "IGraphicsCmd" interface 
***************************************************************************************************/
cb_guid_define( IGraphicsCmd_IID , 0x4B596A8C , 0x92554385 , 0x964D7CE9 , 0xA6422472 );
class IGraphicsCmd;
typedef icubic::iface_object< IGraphicsCmd , IGraphicsCmd_IID >		iGraphicsCmd;
typedef icubic::iface_reference< IGraphicsCmd , IGraphicsCmd_IID >	rGraphicsCmd;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphicsCmd
{
public:
//=================================================================================================
//!	execute cmd
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ExecuteCmd
		(
		IGraphicsAttrCmd*	attr
		) = 0;
};
/**************************************************************************************************
 "IGraphicsCmdsInfo" interface 
***************************************************************************************************/
cb_guid_define( IGraphicsCmdsInfo_IID , 0x470A7614 , 0x63754de3 , 0xB0005C74 , 0xBEF4CC99 );
class IGraphicsCmdsInfo;
typedef icubic::iface_object< IGraphicsCmdsInfo , IGraphicsCmdsInfo_IID >		iGraphicsCmdsInfo;
typedef icubic::iface_reference< IGraphicsCmdsInfo , IGraphicsCmdsInfo_IID >	rGraphicsCmdsInfo;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphicsCmdsInfo
{
public:
	class CmdSeg
	{
	public:
		CmdSeg*			m_next;
		IGraphicsCmd*	m_cmd;
		CmdSeg() : m_next(0) , m_cmd(0){}
		virtual
		~CmdSeg(){}
	};
	class Info
	{
	public:
		CmdSeg*			m_first;
		Info() : m_first(0){}
	};
public:
//=================================================================================================
//!	get info
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
const Info* cb_call GetGraphicsCmdsInfo() = 0;
};
/**************************************************************************************************
 "IGraphicsCmds" interface 
***************************************************************************************************/
cb_guid_define( IGraphicsCmds_IID , 0x981CDD42 , 0xC38C4410 , 0xA288E4BE , 0xD01AB1FF );
class IGraphicsCmds;
typedef icubic::iface_object< IGraphicsCmds , IGraphicsCmds_IID >		iGraphicsCmds;
typedef icubic::iface_reference< IGraphicsCmds , IGraphicsCmds_IID >	rGraphicsCmds;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphicsCmds : public IGraphicsCmdsInfo
{
public:
//=================================================================================================
//!	delete all cmds
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Reset() = 0;
//=================================================================================================
//!	delete all cmds
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call AddCmd
		(
		iGraphicsCmd&		cmd
		) = 0;
};
/**************************************************************************************************
 "IGraphicsCmdsPlayer" interface 
***************************************************************************************************/
cb_guid_define( IGraphicsCmdsPlayer_IID , 0xCC2D662F , 0xDDA048df , 0xA0ED294C , 0x20CDEBB9 );
class IGraphicsCmdsPlayer;
typedef icubic::iface_object< IGraphicsCmdsPlayer , IGraphicsCmdsPlayer_IID >		iGraphicsCmdsPlayer;
typedef icubic::iface_reference< IGraphicsCmdsPlayer , IGraphicsCmdsPlayer_IID >	rGraphicsCmdsPlayer;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IGraphicsCmdsPlayer
{
public:
//=================================================================================================
//!	execute cmds
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ExecuteCmds
		(
		iSurfaceDest&		surface , 
		const faffine&		vtod , 
		const DPI&			dpi , 
		const fsize&		view , 
		IGraphicsCmdsInfo*	cmds
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
