/*************************************************************************************************/
/*!
   	@file		jointbevel.h
	@author 	Fanzo
 	@date 		2008/3/13
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"JointBevel" class 
**************************************************************************************************/
class JointBevel : 
	virtual public object_base , 
	public IJoint
{
	query_begin();
	iface_hook( IJoint , IJoint_IID )
	query_end( object_base );
	
// variable member
private:

// private functions
private:

// "IJoint" interface functions
public:
//=================================================================================================
//!	insert joint
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* cb_call InsertJoint
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		pos , 
		const fvector2&		s_vec ,
		const fvector2&		s_w0 ,
		const fvector2&		s_w1 ,
		const fvector2&		t_vec ,
		const fvector2&		t_w0 ,
		const fvector2&		t_w1 , 
		float				samplescale
		)
{
	if( node == 0 )
		return node;
	float	out	= s_vec.Outer( t_vec );
	if( out == 0.0f )
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , t_w1 );
	}
	else if( out > 0.0f )
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , pos );
		outline->InsertNode( node , t_w1 );
	}
	else
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , pos );
		node	= outline->InsertNode( node , t_w0 );
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , t_w1 );
	}
	return node;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
JointBevel()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
