/*************************************************************************************************/
/*!
   	@file		GraphicsMisc.h
	@author 	Fanzo
 	@date 		2008/5/21
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	polygon to rect
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool PolygonToRect
		(
		frect*			r , 
		const fvector2	pnt[4]
		)
{
	int		indexbuf[5]	= { 0 , 1 , 2 , 3 , 0 };
	int*	index	= &indexbuf[0];
	if( pnt[index[0]].y != pnt[index[1]].y )
		index++;
	if( pnt[index[0]].y != pnt[index[1]].y
	||  pnt[index[1]].x != pnt[index[2]].x
	||  pnt[index[2]].y != pnt[index[3]].y
	||  pnt[index[3]].x != pnt[index[0]].x )
		return false;
	
	// normalize
	if( pnt[index[0]].x > pnt[index[2]].x )
	{
		swap( &index[0] , &index[1] );
		swap( &index[2] , &index[3] );
	}
	if( pnt[index[0]].y > pnt[index[2]].y )
	{
		swap( &index[0] , &index[3] );
		swap( &index[1] , &index[2] );
	}
	// store
	store( r , frect( pnt[index[0]] , pnt[index[2]] ) );
	return true;
}
//=================================================================================================
//!	sort and remove same value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
int SortAndRemoveSame
		(
		t_class*	p , 
		int			num
		)
{
	if( num == 1 )
		return num;

	quicksort( p , num );
	int		i;
	t_class	*s	= p;
	t_class	*t	= p + 1;
	for( i = 1 ; i < num ; i++ )
	{
		if( *s != *t )
		{
			s++;
			*s = *t;
		}
		t++;
	}
	return ( s - p ) + 1;
}
};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
