/*************************************************************************************************/
/*!
   	@file		iListdata.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IListNode" interface 
***************************************************************************************************/
cb_guid_define( IListNode_IID , 0xC992AF35 , 0xB5F341b3 , 0xB2979795 , 0x08C584F3 );
class IListNode;
typedef icubic::iface_object< IListNode , IListNode_IID >		iListNode;
typedef icubic::iface_reference< IListNode , IListNode_IID >	rListNode;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IListNode
{
public:
//=================================================================================================
//!	set prev
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call SetPrevWithoutLink
		(
		iListNode&		prev
		) = 0;
//=================================================================================================
//!	get prev
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iListNode cb_call GetPrev() = 0;
//=================================================================================================
//!	get next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
iListNode cb_call GetNext() = 0;
//=================================================================================================
//!	insert next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call InsertNext
		(
		iListNode&		next
		) = 0;
//=================================================================================================
//!	remove next
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call RemoveNext() = 0;
//=================================================================================================
//!	remove
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call Remove() = 0;
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
