/*************************************************************************************************/
/*!
   	@file		ifilestream.h
	@author 	Fanzo
 	@date 		2008/3/26
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum SeekOrigin
{
	Begin_SeekOrigin , 
	Current_SeekOrigin , 
	End_SeekOrigin
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IStreamRead" interface 
***************************************************************************************************/
cb_guid_define( IStreamRead_IID , 0xDDEC3631 , 0x9FAC44e6 , 0x8A44DAAE , 0xF0E5C0B2 );
class IStreamRead;
typedef icubic::iface_object< IStreamRead , IStreamRead_IID >		iStreamRead;
typedef icubic::iface_reference< IStreamRead , IStreamRead_IID >	rStreamRead;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IStreamRead
{
public:
//=================================================================================================
//!	get position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
uint64 cb_call GetPosition()const = 0;
//=================================================================================================
//!	Read
//!	@retval			actuary read element num
//-------------------------------------------------------------------------------------------------
virtual
int32 cb_call Read
		(
		void		*pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		) = 0;
};
/**************************************************************************************************
 "IStreamWrite" interface 
***************************************************************************************************/
cb_guid_define( IStreamWrite_IID , 0xCC95C781 , 0xCDA643c0 , 0xB38A4AF6 , 0xDC32CB06 );
class IStreamWrite;
typedef icubic::iface_object< IStreamWrite , IStreamWrite_IID >	iStreamWrite;
typedef icubic::iface_reference< IStreamWrite , IStreamWrite_IID >	rStreamWrite;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IStreamWrite
{
public:
//=================================================================================================
//!	write
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Write
		(
		const void*	pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		) = 0;
};

/**************************************************************************************************
 "IFileStreamRead" interface 
***************************************************************************************************/
cb_guid_define( IFileStreamRead_IID , 0xFBE611C4 , 0x6F8840ab , 0xBC69192F , 0x7873CD27 );
class IFileStreamRead;
typedef icubic::iface_object< IFileStreamRead , IFileStreamRead_IID >	iFileStreamRead;
typedef icubic::iface_reference< IFileStreamRead , IFileStreamRead_IID >	rFileStreamRead;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFileStreamRead : public IStreamRead
{
public:
//=================================================================================================
//!	get size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
uint64 cb_call GetSize() = 0;
//=================================================================================================
//!	seek
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		) = 0;
};
/**************************************************************************************************
 "IFileStreamWrite" interface 
***************************************************************************************************/
cb_guid_define( IFileStreamWrite_IID , 0x54EDB16A , 0x60D441ef , 0x9AF2C71A , 0xC42F27C6 );
class IFileStreamWrite;
typedef icubic::iface_object< IFileStreamWrite , IFileStreamWrite_IID >		iFileStreamWrite;
typedef icubic::iface_reference< IFileStreamWrite , IFileStreamWrite_IID >	rFileStreamWrite;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IFileStreamWrite : public IStreamWrite
{
public:
//=================================================================================================
//!	seek
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
cb_inline
bool SaveString
		(
		IStreamWrite*	file , 
		const wstring&	str
		)
{
	long	len	= str.length();
	if( false == file->Write( &len , sizeof(len) , 1 , Little_EndianType ) )
		return false;
	if( false == file->Write( str.c_str() , sizeof(wchar_t) , len , Little_EndianType ) )
		return false;
	return true;
}
//=================================================================================================
cb_inline
bool LoadString
		(
		IStreamRead*	file , 
		wstring*		str
		)
{
	long	len;
	if( false == file->Read( &len , sizeof(len) , 1 , Little_EndianType ) )
		return false;
	wchar_t*	p = new wchar_t[len+1];
	if( len != file->Read( p , sizeof(wchar_t) , len , Little_EndianType ) )
	{
		delete []p;
		return false;
	}
	p[len]	= L'\0';
	*str	= p;
	delete []p;
	return true;
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
