/*************************************************************************************************/
/*!
   	@file		ResourceAccess.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define
#ifdef cb_windows
/**************************************************************************************************
"ResourceReader" class 
**************************************************************************************************/
class ResourceReader : 
	virtual public object_base , 
	public IFileStreamRead
{
// query
	query_begin();
	iface_hook( IStreamRead , IStreamRead_IID )
	iface_hook( IFileStreamRead , IFileStreamRead_IID )
	query_end( object_base );
	
// variable member
private:
	int64	m_position;
	int64	m_size;
	LPVOID	m_pdata;
	
// "IStreamRead" interface functions
public:
//=================================================================================================
//!	get position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
uint64 cb_call GetPosition()const
{
	if( m_pdata == NULL )
		return 0;
	return m_position;
}
//=================================================================================================
//!	Read
//!	@retval			actually read element num
//-------------------------------------------------------------------------------------------------
int32 cb_call Read
		(
		void		*pbuf , 
		int32		element_size ,		
		int32		element_num , 
		EndianType	endian
		)
{
	if( m_pdata == NULL )
		return 0;

	int32	size = element_size * element_num;
	if( m_size < m_position + size )
		return 0;
	MemoryCopy( pbuf , ( (const uint8*)m_pdata ) + m_position , size );
	m_position += size;
	
#if defined( cb_little_endian ) 
	if( element_size != 1 && endian == Big_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )element_num );
#elif defined( cb_big_endian )	
	if( element_size != 1 && endian == Little_EndianType )
		EndianChange( pbuf , ( int32 )element_size , ( int32 )element_num );
#else
	#error	unknown endian.
#endif
	return element_num;
}
// "IStreamFileRead" interface functions
public:
//=================================================================================================
//!	get size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
uint64 cb_call GetSize()
{
	if( m_pdata == NULL )
		return 0;
	return m_size;
}
//=================================================================================================
//!	seek
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call Seek
		(
		int64			offset , 
		SeekOrigin		origin = Begin_SeekOrigin
		)
{
	if( m_pdata == NULL )
		return false;
	if( origin == Begin_SeekOrigin )
	{
		if( 0 <= offset && offset <= m_size )
		{
			m_position	= offset;
			return true;
		}
	}
	else if( origin == Current_SeekOrigin )
	{
		if( 0 <= offset + m_position && offset + m_position <= m_size )
		{
			m_position += offset;
			return true;
		}
	}
	else if( origin == End_SeekOrigin )
	{
		if( 0 <= m_size + offset && m_size + offset <= m_size )
		{
			m_position	= m_size + offset;
			return true;
		}
	}
	return false;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
ResourceReader() : m_pdata( NULL ) , m_size( 0 ) , m_position( 0 )
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
~ResourceReader()
{
	Close();
}
//=================================================================================================
//!	open
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool Open
		(
		HMODULE			hmodule , 
		const wchar_t*	name , 
		const wchar_t*	type
		)
{
	Close();
	
	HRSRC	hrsc	= ::FindResourceW( hmodule , name , type );
	if( hrsc == NULL )
		return false;
	DWORD	size	= ::SizeofResource( hmodule , hrsc );
	HGLOBAL	hglobal	= ::LoadResource( hmodule , hrsc );
	if( hglobal == NULL )
		return false;
	LPVOID	pdata = ::LockResource( hglobal );
	if( pdata == NULL )
		return false;		// don't need FreeResource
	
	m_position	= 0;
	m_size		= size;
	m_pdata		= pdata;
	return true;
}
//=================================================================================================
//!	close
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void Close()
{
	// don't need UnlockResource
	m_pdata		= NULL;
	m_size		= 0;
	m_position	= 0;
}
};
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
