/*************************************************************************************************/
/*!
   	@file		ioutlinegen.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iOutline.h"
#include	"iPathSegment.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
 "IOutlineGen" interface 
***************************************************************************************************/
cb_guid_define( IOutlineGen_IID , 0xF452ED22 , 0xD4F246a6 , 0x86458A0D , 0x6F54C45C );
class IOutlineGen;
typedef icubic::iface_object< IOutlineGen , IOutlineGen_IID >	iOutlineGen;
typedef icubic::iface_reference< IOutlineGen , IOutlineGen_IID >	rOutlineGen;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IOutlineGen
{
public:
//=================================================================================================
//!	set samplescale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetSampleScale
		(
		float		samplescale
		) = 0;
//=================================================================================================
//!	begin
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call BeginOutline
		(
		iOutline	&outline , 
		bool		close
		) = 0;
//=================================================================================================
//!	gen outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call GenerateOutline
		(
		IPathSegment*	ps
		) = 0;
//=================================================================================================
//!	end
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call EndOutline() = 0;
};
/**************************************************************************************************
 "IOutlineGenStroke" interface 
***************************************************************************************************/
cb_guid_define( IOutlineGenStroke_IID , 0x4DCAE590 , 0xF1974dd2 , 0xA7C746BA , 0xA36D303B );
class IOutlineGenStroke;
typedef icubic::iface_object< IOutlineGenStroke , IOutlineGenStroke_IID >		iOutlineGenStroke;
typedef icubic::iface_reference< IOutlineGenStroke , IOutlineGenStroke_IID >	rOutlineGenStroke;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IOutlineGenStroke : public IOutlineGen
{
public:
//=================================================================================================
//!	set width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetStrokeWidth
		(
		float	w
		) = 0;
};

/**************************************************************************************************
 "IJoint" interface 
***************************************************************************************************/
cb_guid_define( IJoint_IID , 0x2A1373BC , 0x5E3C454b , 0x95312D50 , 0x5FAD6252 );
class IJoint;
typedef icubic::iface_object< IJoint , IJoint_IID >	iJoint;
typedef icubic::iface_reference< IJoint , IJoint_IID >	rJoint;
///////////////////////////////////////////////////////////////////////////////////////////////////
class IJoint
{
public:
//=================================================================================================
//!	insert joint
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
virtual
OutlineNodePtr* cb_call InsertJoint
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		pos , 
		const fvector2&		s_vec ,
		const fvector2&		s_w0 ,
		const fvector2&		s_w1 ,
		const fvector2&		t_vec ,
		const fvector2&		t_w0 ,
		const fvector2&		t_w1 , 
		float				samplescale
		) = 0;
};
/**************************************************************************************************
 "ICap" interface 
***************************************************************************************************/
cb_guid_define( ICap_IID , 0xB6B39B15 , 0xA293443b , 0x9DCB096C , 0x90D8A2A5 );
class ICap;
typedef icubic::iface_object< ICap , ICap_IID >		iCap;
typedef icubic::iface_reference< ICap , ICap_IID >	rCap;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ICap
{
public:
//=================================================================================================
//!	insert cap
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
virtual
OutlineNodePtr* cb_call InsertCap
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		vec , 
		const fvector2&		w0 ,
		const fvector2&		w1 , 
		float				samplescale
		) = 0;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
