/*************************************************************************************************/
/*!
   	@file		sourcegeneratorsolidcolor.h
	@author 	Fanzo
 	@date 		2008/3/24
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iSource.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"SourcePaintSolidColor" class 
**************************************************************************************************/
class SourcePaintSolidColor : 
	public ISourcePaintSolidColor , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( ISourcePaint , ISourcePaint_IID )
	iface_hook( ISourcePaintSolidColor , ISourcePaintSolidColor_IID )
	query_end( object_base )
	
// variable member
private:
	rgba		m_color;
		
// private functions
private:

public:

// "ISourcePaint" interface functions
//=================================================================================================
SourceType cb_call SourcePaintType()
{
	return Color_SourceType;
}
//=================================================================================================
rgba cb_call SourcePaintColor()
{
	return m_color;
}
//=================================================================================================
pixelformat	cb_call SourcePaintImageFormat()
{
	return rgba_pixelformat;
}
//=================================================================================================
bool cb_call BeginSourcePaintImage
		(
		const LogicalUnit&	lu
		)
{
	return false;
}
//=================================================================================================
void cb_call SourcePaintImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
}
//=================================================================================================
void cb_call EndSourcePaintImage()
{
}
// "ISourcePaintSolidColor" interface functions
//=================================================================================================
void cb_call SetColor
		(
		const rgba&	color
		)
{
	m_color	= color;
}
//=================================================================================================
rgba cb_call GetColor()
{
	return m_color;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourcePaintSolidColor()
{
}
};

/**************************************************************************************************
"SourceTextureSolidColor" class 
**************************************************************************************************/
class SourceTextureSolidColor : 
	public ISourceTextureSolidColor , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( ISourceTexture , ISourceTexture_IID )
	iface_hook( ISourceTextureSolidColor , ISourceTextureSolidColor_IID )
	query_end( object_base )
	
// variable member
private:
	rgba		m_color;
		
// private functions
private:

public:

// "ISourceTexture" interface functions
//=================================================================================================
isize cb_call SourceTextureSize()
{
	return isize( 1 , 1 );
}
//=================================================================================================
LogicalCoord cb_call GetLogicalCoord()
{
	return LogicalCoord();
}
//=================================================================================================
SourceType cb_call SourceTextureType()
{
	return Color_SourceType;
}
//=================================================================================================
rgba cb_call SourceTextureColor()
{
	return m_color;
}
//=================================================================================================
pixelformat	cb_call SourceTextureImageFormat()
{
	return rgba_pixelformat;
}
//=================================================================================================
bool cb_call BeginSourceTextureImage()
{
	return false;
}
//=================================================================================================
void cb_call SourceTextureImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
}
//=================================================================================================
void cb_call EndSourceTextureImage()
{
}
// "ISourceTextureSolidColor" interface functions
public:
//=================================================================================================
void cb_call SetColor
		(
		const rgba&	color
		)
{
	m_color	= color;
}
//=================================================================================================
rgba cb_call GetColor()
{
	return m_color;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
SourceTextureSolidColor()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
