/*************************************************************************************************/
/*!
   	@file		PathLine.h
	@author 	Fanzo
 	@date 		2008/5/3
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iPathSegment.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"PathLine_bs" class 
**************************************************************************************************/
class PathLine_bs : 
	public IPathSegment
{
	cb_copy_impossible( PathLine_bs );

// variable member
private:
	float		m_a[2] , m_b[2];
	
// "IPath" interface functions
public:
//=================================================================================================
//!	IsExist
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call IsExist()
{
	if( m_a[0]==0.0f && m_a[1]==0.0f )
		return false;
	return true;
}
//=================================================================================================
//!	get optimum samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumSample
		(
		float	samplescale
		)
{
	return 2;
}
//=================================================================================================
//!	get optimum length samplenum
//!	@retval			---
//-------------------------------------------------------------------------------------------------
int cb_call GetOptimumLengthSample()
{
	return 2;
}
//=================================================================================================
//!	value
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Value
		(
		float	t
		)
{
	return fvector2( m_a[0] * t + m_b[0] , m_a[1] * t + m_b[1] );
}
//=================================================================================================
//!	Differential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call Differential
		(
		float	t
		)
{
	return fvector2( m_a[0] , m_a[1] );
}
//=================================================================================================
//!	SecondOrderDifferential
//!	@retval			---
//-------------------------------------------------------------------------------------------------
fvector2 cb_call SecondOrderDifferential
		(
		float	t
		)
{
	return fvector2( 0.0f , 0.0f );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathLine_bs()
{
	m_a[0]	= 0.0f;
	m_a[1]	= 0.0f;
	m_b[0]	= 0.0f;
	m_b[1]	= 0.0f;
}
//=================================================================================================
//!	initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializeParam
		(
		float			a0 , 
		float			b0 , 
		float			a1 , 
		float			b1 , 
		const faffine&	affine
		)
{
	int	i;
	for( i = 0 ; i < 2 ; i++ )
	{
		m_a[i]	= affine.m[i][0] * a0 + affine.m[i][1] * a1;
		m_b[i]	= affine.m[i][0] * b0 + affine.m[i][1] * b1 + affine.m[i][2];
	}
}
//=================================================================================================
//!	initialize position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializePosition
		(
		float			sx , 
		float			sy , 
		float			tx , 
		float			ty ,
		const faffine&	affine
		)
{
	InitializeParam( tx - sx , sx , ty - sy , sy , affine );
}
//=================================================================================================
//!	initialize position
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializePosition
		(
		const fvector2&	sp , 
		const fvector2&	tp , 
		const faffine&	affine
		)
{
	InitializeParam( tp.x - sp.x , sp.x , tp.y - sp.y , sp.y , affine );
}
};
/**************************************************************************************************
"PathLine" class 
**************************************************************************************************/
class PathLine : 
	virtual public object_base , 
	public PathLine_bs
{
// query
	query_begin();
	iface_hook( IPathSegment , IPathSegment_IID )
	query_end( object_base );
	
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
PathLine()
{
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
