/*************************************************************************************************/
/*!
   	@file		OutlineGenDash.h
	@author 	Fanzo
 	@date 		2008/3/11
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutlineGen.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"OutlineGenDash" class 
**************************************************************************************************/
template<class t_interface>
class OutlineGenDash_bs : 
	public t_interface
{
// variable member
private:
	float			m_width_r2;

	iJoint			m_joint;
	iCap			m_start_cap;
	iCap			m_end_cap;
	iCap			m_dash_cap;

	// creator
	instance<PathLine>			m_line_ps;
	PathSegmentSamplerDash		m_sampler_dash;
	PathSegmentSamplerStroke	m_sampler_stroke;
	iOutline					m_outline;
	
	// init param
	bool						m_close;
	float						m_samplescale;
	Array<float>				m_dash;
	bool						m_stroke;
	bool						m_init_dash_f;
	int							m_init_dash_off;
	float						m_init_dash_dl;
	
	// bigin end work
	OutlineNodePtr*				m_start_node;
	OutlineNodePtr*				m_node;
	int							m_dash_off;
	float						m_dash_dl;
	
	fvector2		m_lpos , m_lvec , m_lw0 , m_lw1;
	bool			m_ff;
	fvector2		m_fpos , m_fvec , m_fw0 , m_fw1;

// private functions
private:
//=================================================================================================
//!	Initialize
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void InitializePath
		(
		IPathSegment*	ps
		)
{
	GetStrokeEdge( ps , 0.0f , m_width_r2 , &m_fpos , &m_fvec , &m_fw0 , &m_fw1 );
	if( m_init_dash_f == true )
	{
		m_node			= &( m_outline->CreateOutline()->m_node );
		m_start_node	= m_node;
	}
}
//=================================================================================================
//!	FinalizePath
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void FinalizePath()
{
	if( m_close == false )
	{
		m_start_cap->InsertCap( m_outline , m_start_node , -m_fvec , m_fw1 , m_fw0 , m_samplescale );
		m_node = m_end_cap->InsertCap( m_outline , m_node , m_lvec , m_lw0 , m_lw1 , m_samplescale );
	}
	else
	{
		if( m_fpos != m_lpos )
		{
			fvector2	v = m_fpos - m_lpos;
			m_line_ps->InitializeParam( v.x , m_lpos.x , v.y , m_lpos.y , faffine() );
			GenerateOutline( (iPathSegment)m_line_ps );
		}
		m_node = m_joint->InsertJoint( m_outline , m_node , m_lpos , m_lvec , m_lw0 , m_lw1 , m_fvec , m_fw0 , m_fw1 , m_samplescale );
		if( m_node == 0 )
		{
			if( m_start_node != 0 )
				m_dash_cap->InsertCap( m_outline , m_start_node , -m_fvec , m_fw1 , m_fw0 , m_samplescale );
		}
		else
		{
			if( m_start_node == 0 )
				m_node = m_dash_cap->InsertCap( m_outline , m_node , m_fvec , m_fw0 , m_fw1 , m_samplescale );
		}
	}
}
// "IOutlineGen" interface functions
public:
//=================================================================================================
void cb_call SetSampleScale
		(
		float		samplescale
		)
{
	m_samplescale	= samplescale;
}
//=================================================================================================
void cb_call BeginOutline
		(
		iOutline	&outline , 
		bool		close
		)
{
	cb_assert( m_outline == false , L"Begin called before End." );
	m_outline		= outline;
	m_close			= close;
	m_ff			= false;
	m_dash_off		= m_init_dash_off;
	m_dash_dl		= m_init_dash_dl;
	m_node			= 0;
	m_start_node	= 0;
}
//=================================================================================================
void cb_call GenerateOutline
		(
		IPathSegment*	ps
		)
{
	cb_assert( m_outline == true , L"Generate called before Begin." );
	if( ps->IsExist() == false )
		return;
		
	// init
	if( m_ff == false )
	{
		m_ff	= true;
		InitializePath( ps );
	}
	// joint
	else if( m_node != 0 )
	{
		fvector2	w0 , w1 , vec;
		GetStrokeEdge( ps , 0.0f , m_width_r2 , 0 , &vec , &w0 , &w1 );
		m_node = m_joint->InsertJoint( m_outline , m_node , m_lpos , m_lvec , m_lw0 , m_lw1 , vec , w0 , w1 , m_samplescale );
	}
	// segment
	if( m_stroke == false )
		m_node	= m_sampler_dash.Sampling( m_outline , m_node , ps , 0.0f , 1.0f , m_dash.GetConstPtr() , m_dash.GetDatanum() , &m_dash_off , &m_dash_dl , m_dash_cap , m_samplescale );
	else
		m_node	= m_sampler_stroke.Sampling( m_outline , m_node , ps , 0.0f , 1.0f , m_samplescale );
	GetStrokeEdge( ps , 1.0f , m_width_r2 , &m_lpos , &m_lvec , &m_lw0 , &m_lw1 );
}
//=================================================================================================
void cb_call EndOutline()
{
	cb_assert( m_outline == true , L"End called before Begin." );
	
	if( m_ff == true )
		FinalizePath();
	m_outline.release();
	m_node	= 0;
}
// "IOutlineGenStroke" interface
public:
//=================================================================================================
void cb_call SetStrokeWidth
		(
		float	w
		)
{
	m_width_r2	= w / 2.0f;
	m_sampler_dash.SetWidth( m_width_r2 );
	m_sampler_stroke.SetWidth( m_width_r2 );
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
OutlineGenDash_bs() : 
		m_width_r2( 0.5f ) , 
		m_dash( Expand_ArrayCashType , 12 ) , 
		m_dash_off( 0 ) , 
		m_dash_dl( 0.0f ) , 
		m_node( 0 ) , 
		m_start_node( 0 ) , 
		m_ff( false ) , 
		m_close( false ) , 
		m_samplescale( 1.0f ) , 
		m_stroke( false ) ,
		m_init_dash_off( 0 ) , 
		m_init_dash_dl( 0.0f ) , 
		m_init_dash_f( true )
{
	m_joint			= instance<JointBevel>();
	m_start_cap		= instance<CapFlat>();
	m_end_cap		= instance<CapFlat>();
	m_dash_cap		= instance<CapFlat>();
	m_sampler_dash.SetWidth( m_width_r2 );
	m_sampler_stroke.SetWidth( m_width_r2 );
}
//=================================================================================================
//!	set inner bridge type
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetInnerBridgeType
		(
		InnerBridgeType	type
		)
{
	m_sampler_dash.SetInnerBridgeType( type );
	m_sampler_stroke.SetInnerBridgeType( type );
}
//=================================================================================================
//!	get width
//!	@retval			---
//-------------------------------------------------------------------------------------------------
float cb_call GetWidth()const
{
	return m_width_r2 * 2.0f;
}
//=================================================================================================
//!	set joint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetJoint
		(
		iJoint		joint
		)
{
	m_joint	= joint;
}
//=================================================================================================
//!	get joint
//!	@retval			---
//-------------------------------------------------------------------------------------------------
iJoint cb_call GetJoint()
{
	return m_joint;
}
//=================================================================================================
//!	set cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetCap
		(
		iCap&		start_cap , 
		iCap&		dash_cap , 
		iCap&		end_cap
		)
{
	m_start_cap	= start_cap;
	m_dash_cap	= dash_cap;
	m_end_cap	= end_cap;
}
//=================================================================================================
//!	get cap
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GetCap
		(
		iCap		*start_cap , 
		iCap		*dash_cap , 
		iCap		*end_cap
		)
{
	if( 0 != start_cap )	*start_cap	= m_start_cap;
	if( 0 != dash_cap )		*dash_cap	= m_dash_cap;
	if( 0 != end_cap )		*end_cap	= m_end_cap;
}
//=================================================================================================
//!	set dot
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetDash
		(
		const float	dashlist[] , 
		int			dashnum , 
		float		offset
		)
{
	m_dash.Resize( dashnum );
	float	length = 0.0f;
	int		d_off;
	for( d_off = 0 ; d_off < dashnum ; d_off++ )
	{
		m_dash[d_off]	= max( 0.0f , dashlist[d_off] );
		length += m_dash[d_off];
	}
	
	if( length <= 0.5f || m_dash.GetDatanum() == 0 )
	{
		m_stroke		= true;
		m_init_dash_f	= true;
		m_init_dash_off	= 0;
		m_init_dash_dl	= 0.0f;
	}
	else
	{
		m_stroke		= false;
		int		loop	= (int)floorf( offset / length );
		m_init_dash_f	= ( (loop * dashnum) & 1 ) == 0 ? true : false;
		float	dl		= offset - loop * length;
		for( d_off = 0 ; d_off < dashnum ; d_off++ )
		{
			if( dl <= m_dash[d_off] )
				break;
			dl -= m_dash[d_off];
			m_init_dash_f	= ( m_init_dash_f ) == true ? false : true;
		}
		m_init_dash_off	= min( dashnum - 1 , d_off );
		m_init_dash_dl	= dl;
	}
}
};
/**************************************************************************************************
"OutlineGenDash" class 
**************************************************************************************************/
class OutlineGenDash : 
	public OutlineGenDash_bs<IOutlineGenStroke> , 
	virtual public object_base
{
// query
	query_begin();
	iface_hook( IOutlineGen , IOutlineGen_IID )
	iface_hook( IOutlineGenStroke , IOutlineGenStroke_IID )
	query_end( object_base );
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
