/*************************************************************************************************/
/*!
   	@file		LoaderImagefile.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"LoaderImagefile" class 
**************************************************************************************************/
class LoaderImagefile : 
	virtual public object_base , 
	public ILoaderImagefile
{
	query_begin();
	iface_hook( ILoaderImagefile , ILoaderImagefile_IID )
	query_end( object_base );
	
// variable member
private:
	Array<iLoaderImagefile>		m_loaders;
	iLoaderImagefile			m_loader;
	
// "ILoaderImagefile" interface functions
public:
//=================================================================================================
bool cb_call CheckImagefileSign
		(
		iFileStreamRead			&reader
		)
{
	int		off , num = m_loaders.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( true == m_loaders[off]->CheckImagefileSign( reader ) )
			return true;
	}
	return false;
}
//=================================================================================================
bool cb_call Load
		(
		iFileStreamRead			&reader
		)
{
	m_loader.release();
	int		off , num = m_loaders.GetDatanum();
	for( off = 0 ; off < num ; off++ )
	{
		if( true == m_loaders[off]->Load( reader ) )
		{
			m_loader	= m_loaders[off];
			return true;
		}
	}
	return false;
}
//=================================================================================================
int32 cb_call GetImageNum()
{
	if( m_loader == false )
		return 0;
	return m_loader->GetImageNum();
}
//=================================================================================================
DPI cb_call GetImageDPI
		(
		int32		imageoff
		)const
{
	if( m_loader == false )
		return DPI();
	return m_loader->GetImageDPI( imageoff );
}
//=================================================================================================
isize cb_call GetImageSize
		(
		int32		imageoff
		)
{
	if( m_loader == false )
		return isize();
	return m_loader->GetImageSize( imageoff );
}
//=================================================================================================
bool cb_call GetImage
		(
		int32		imageoff , 
		pixelformat	destformat , 
		void*		dest , 
		int			pitchbyte
		)
{
	if( m_loader == false )
		return false;
	return m_loader->GetImage( imageoff , destformat , dest , pitchbyte );
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
LoaderImagefile()
{
	AddLoader( (iLoaderImagefile)instance<LoaderImagefile_bmp>() );
	AddLoader( (iLoaderImagefile)instance<LoaderImagefile_png>() );
	AddLoader( (iLoaderImagefile)instance<LoaderImagefile_psd>() );
}
//=================================================================================================
//!	add loader
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool AddLoader
		(
		iLoaderImagefile&	loader
		)
{
	if( loader == false )
		return false;
	m_loaders[ m_loaders.Add() ]	= loader;
	return true;
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
