/*************************************************************************************************/
/*!
   	@file		jointround.h
	@author 	Fanzo
 	@date 		2008/3/11
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutlineGen.h"
#include	<math.h>

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"JointRound" class 
**************************************************************************************************/
class JointRound : 
	virtual public object_base , 
	public IJoint
{
	query_begin();
	iface_hook( IJoint , IJoint_IID )
	query_end( object_base );
	
// variable member
private:
	PathSegmentSamplerPaint	m_sampler;
	instance<PathArc>	m_arc_ps;

// private functions
private:
// "IJoint" interface functions
public:
//=================================================================================================
//!	insert joint
//!	@retval			last node pointer
//-------------------------------------------------------------------------------------------------
OutlineNodePtr* cb_call InsertJoint
		(
		iOutline			&outline ,
		OutlineNodePtr*		node , 
		const fvector2&		pos , 
		const fvector2&		s_vec ,
		const fvector2&		s_w0 ,
		const fvector2&		s_w1 ,
		const fvector2&		t_vec ,
		const fvector2&		t_w0 ,
		const fvector2&		t_w1 , 
		float				samplescale
		)
{
	if( node == 0 )
		return node;
	float	out	= s_vec.Outer( t_vec );

	if( -0.001f <= out && out <= 0.001f )
	{
		if( s_vec.Inner( t_vec ) < 0.0f )
		{
			m_arc_ps->InitializeHalfCircle( s_w0 , s_w1 , s_vec , faffine() );
			node	= m_sampler.Sampling( outline , node , (iPathSegment)m_arc_ps , 0.0f , 1.0f , samplescale );
		
			outline->InsertNode( node , s_w1 );
			outline->InsertNode( node , t_w1 );
		}
		else
		{
			node	= outline->InsertNode( node , s_w0 );
			node	= outline->InsertNode( node , t_w0 );
			outline->InsertNode( node , s_w1 );
			outline->InsertNode( node , t_w1 );
		}
	}
	else if( out >= 0.0f )
	{
		m_arc_ps->InitializeCirclePosition( s_w0 , t_w0 , pos , faffine() );
		node	= m_sampler.Sampling( outline , node , (iPathSegment)m_arc_ps , 0.0f , 1.0f , samplescale );
		
		outline->InsertNode( node , s_w1 );
		outline->InsertNode( node , pos );
		outline->InsertNode( node , t_w1 );
	}
	else
	{
		node	= outline->InsertNode( node , s_w0 );
		node	= outline->InsertNode( node , pos );
		node	= outline->InsertNode( node , t_w0 );
		
		m_arc_ps->InitializeCirclePosition( t_w1 , s_w1 , pos , faffine() );
		m_sampler.Sampling( outline , node , (iPathSegment)m_arc_ps , 0.0f , 1.0f , samplescale );
	}
	return node;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
JointRound()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
