/*************************************************************************************************/
/*!
   	@file		guid.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		cb_guid_define( NAME , D1 , D2 , D3 , D4 )				\
class NAME : public icubic::guid											\
{																		\
public:																	\
	NAME() : icubic::guid( D1, D2, D3, D4 ){}							\
	static																\
	const NAME& get_const()												\
	{																	\
		static NAME	obj;												\
		return obj;														\
	}																	\
};														

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/****************************************************************************
"guid" class 
****************************************************************************/
/*===========================================================================
//!	
===========================================================================*/
/////////////////////////////////////////////////////////////////////////////
class guid
{
// variable member
public:
	uint32			m_Data[ 4 ];

// private functions
private:
// protect functions
protected:
// public functions
public:
//=================================================================================================
guid()
{
	m_Data[0]	= 0;
	m_Data[1]	= 0;
	m_Data[2]	= 0;
	m_Data[3]	= 0;
}
//=======================================================================
//!	construct
//-----------------------------------------------------------------------
guid
		(
		uint32		data1 ,
		uint32		data2 ,
		uint32		data3 ,
		uint32		data4
		)
{
	m_Data[ 0 ] = data1;
	m_Data[ 1 ] = data2;
	m_Data[ 2 ] = data3;
	m_Data[ 3 ] = data4;
}
//=======================================================================
//!	compare
//!	@retval			---
//-----------------------------------------------------------------------
bool operator==
		( 
		const guid& obj 
		)const
{
	if( m_Data[ 0 ] != obj.m_Data[ 0 ] )
		return false;
	if( m_Data[ 1 ] != obj.m_Data[ 1 ] )
		return false;
	if( m_Data[ 2 ] != obj.m_Data[ 2 ] )
		return false;
	if( m_Data[ 3 ] != obj.m_Data[ 3 ] )
		return false;
	return true;
}
//=======================================================================
//!	compare
//!	@retval			---
//-----------------------------------------------------------------------
bool operator!=
		( 
		const guid& obj 
		)const
{
	if( *this == obj )
		return false;
	return true;
}
//=======================================================================
//!	Null?
//!	@retval			---
//-----------------------------------------------------------------------
bool IsNull()const
{
	if( m_Data[ 0 ] != 0 )
		return false;
	if( m_Data[ 1 ] != 0 )
		return false;
	if( m_Data[ 2 ] != 0 )
		return false;
	if( m_Data[ 3 ] != 0 )
		return false;
	return true;
}
};

cb_guid_define( null_guid , 0x00000000 , 0x00000000 , 0x00000000 , 0x00000000 );

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
