/*************************************************************************************************/
/*!
   	@file		Parser.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<string>
#include <boost/regex.hpp>

#pragma pack( push , 8 )		//set align

namespace icubic
{
using namespace std;

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

#define		parse_map_start()									\
protected:														\
bool ParseNode													\
		(														\
		int				s_node ,								\
		int*			t_node , 								\
		const wstring&	str ,									\
		int*			pos , 									\
		int*			errpos , 								\
		void*			param									\
		)														\
{

#define		parse_map_edge( _snode , _tnode , _func )			\
	if( s_node == _snode )										\
	{															\
		int		t_pos = *pos;									\
		if( true == _func( str , &t_pos , errpos ) )			\
		{														\
			*t_node	= _tnode;									\
			*pos	= t_pos;									\
			if( errpos != 0 && *errpos < t_pos )				\
				*errpos = t_pos;								\
			return true;										\
		}														\
		else													\
		{														\
			if( errpos != 0 && *errpos < t_pos )				\
				*errpos = t_pos;								\
		}														\
	}

#define		parse_map_edge_p( _snode , _tnode , _func )			\
	if( s_node == _snode )										\
	{															\
		int		t_pos = *pos;									\
		if( true == _func( str , &t_pos , errpos , param ) )	\
		{														\
			*t_node	= _tnode;									\
			*pos	= t_pos;									\
			if( errpos != 0 && *errpos < t_pos )				\
				*errpos = t_pos;								\
			return true;										\
		}														\
		else													\
		{														\
			if( errpos != 0 && *errpos < t_pos )				\
				*errpos = t_pos;								\
		}														\
	}

#define		parse_map_end()										\
	return false;												\
}
///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

template<class t_class>
class ConvertTable
{
public:
	wstring		m_name;
	t_class		m_value;
	ConvertTable
			(
			const wchar_t*	name , 
			const t_class&	value
			) : m_name( name ) , m_value( value )
	{
	}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	match string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
bool MatchString
		(
		const wstring&		str , 
		int*				pos , 
		const wchar_t*		regex , 
		wstring*			result
		)
{
	boost::match_results<const wchar_t*> results;
	if( false == boost::regex_search( ( const wchar_t* )str.c_str() + ( *pos ) , results , boost::wregex( regex ) , boost::regex_constants::match_continuous ) )
		return false;
	*pos	+= results.str( 0 ).length();
	if( result != 0 )
		*result	= results.str( 0 );
	return true;
}
//=================================================================================================
//!	match string
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int MatchStrings
		(
		const wstring&		str , 
		int*				pos , 
		const wchar_t**		regex , 
		int					regexnum , 
		wstring*			result
		)
{
	int		regexoff;
	for( regexoff = 0 ; regexoff < regexnum ; regexoff++ )
	{
		if( true == MatchString( str , pos , regex[ regexoff ] , result ) )
			return regexoff;
	}
	return -1;
}
//=================================================================================================
//!	match table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
bool MatchTable
		(
		const wstring&					str , 
		int*							pos , 
		const ConvertTable<t_class>*	tbl , 
		int								tblnum , 
		t_class*						value
		)
{
	const wchar_t*	str1 = ( const wchar_t* )str.c_str() + (*pos);
	
	int		tbloff;
	for( tbloff = 0 ; tbloff < tblnum ; tbloff++ )
	{
		const wchar_t*	str2 = tbl[tbloff].m_name.c_str();
		while( *str2 != L'\0' )
		{
			if( *str1 != *str2 )
				break;
			str1++;
			str2++;
		}
		if( *str2 == L'\0' )
		{
			store( value , tbl[tbloff].m_value );
			*pos	+= tbl[tbloff].m_name.length();
			return true;
		}
/*
		if( true == MatchString( str , pos , tbl[tbloff].m_name.c_str() , 0 ) )
		{
			store( value , tbl[tbloff].m_value );
			return true;
		}
*/
	}
	return false;
}
//=================================================================================================
//!	match table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
wstring MatchTable
		(
		const ConvertTable<t_class>*	tbl , 
		int								tblnum , 
		t_class&						value , 
		const wchar_t*					def
		)
{
	int		tbloff;
	for( tbloff = 0 ; tbloff < tblnum ; tbloff++ )
	{
		if( tbl[ tbloff ].m_value == value )
			return tbl[ tbloff ].m_name;
	}
	return wstring( def );
}
//=================================================================================================
//!	match table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_class>
wstring MatchTable
		(
		const ConvertTable<t_class>*	tbl , 
		int								tblnum , 
		const t_class&					value
		)
{
	int		tbloff;
	for( tbloff = 0 ; tbloff < tblnum ; tbloff++ )
	{
		if( tbl[ tbloff ].m_value == value )
			return tbl[ tbloff ].m_name;
	}
	return tbl[tbloff].m_name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"Parser" class 
**************************************************************************************************/
class Parser
{
// variable member
public:
	enum
	{
		start_node_id	= 0 , 
		end_node_id		= -1 , 
	};
	
// protected functions
protected:
//=================================================================================================
//!	parse node
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
bool ParseNode
		(
		int				s_node , 
		int*			t_node , 
		const wstring&	str , 
		int*			pos , 
		int*			errpos , 
		void*			param
		) = 0;

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
Parser()
{
}
//=================================================================================================
//!	destruct
//-------------------------------------------------------------------------------------------------
virtual
~Parser()
{
}
//=================================================================================================
//!	Parse
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool Parse
		(
		const wstring&		str , 
		int*				pos		= 0 , 
		int*				errpos	= 0 , 
		void*				param	= 0
		)
{
	int		t_pos	= ( pos == 0 ) ? 0 : *pos;
	int		node	= start_node_id;
	do
	{
		if( false == ParseNode( node , &node , str , &t_pos , errpos , param ) )
		{
			if( errpos != 0 && *errpos < t_pos )
				*errpos = t_pos;
			return false;
		}
	}while( node != end_node_id );
	if( pos != 0 )
		*pos	= t_pos;
	if( errpos != 0 && *errpos < t_pos )
		*errpos = t_pos;
	return true;
}
};
/**************************************************************************************************
"IntegerParser" class 
**************************************************************************************************/
template<int t_base>
class IntegerParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	long		m_value;

// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	if( str[ *pos ] == L' ' || str[ *pos ] == L'\t' )
		return false;
	const wchar_t*	p = &str.c_str()[ *pos ];
	wchar_t*		ep= 0;
	long		v = wcstol( p , &ep , t_base );
	if( p == ep )
		return false;
	m_value	= v;
	*pos	+= ( ep - p );
	return true;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
IntegerParser() : m_value( 0 )
{
}
};
/**************************************************************************************************
"RealParser" class 
**************************************************************************************************/
class RealParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	double		m_value;

// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	if( str[ *pos ] == L' ' || str[ *pos ] == L'\t' )
		return false;
	const wchar_t*	p = &str.c_str()[ *pos ];
	wchar_t*		ep= 0;
	double			v = wcstod( p , &ep );
	if( p == ep )
		return false;
	m_value	= v;
	*pos	+= ( ep - p );
	return true;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
RealParser() : m_value( 0.0 )
{
}
};
/**************************************************************************************************
"BooleanParser" class 
**************************************************************************************************/
class BooleanParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	bool		m_value;

// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	if( true == MatchString( str , pos , L"true" , 0 ) )
	{
		m_value = true;
		return true;
	}
	if( true == MatchString( str , pos , L"false" , 0 ) )
	{
		m_value = false;
		return true;
	}
	return false;
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
BooleanParser() : m_value( false )
{
}
};
/**************************************************************************************************
"SpaceParser" class 
**************************************************************************************************/
/*
class SpaceParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	wstring		m_value;
	
// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	return MatchString( str , pos , L"[ \\n\\r\\t]+" , &m_value );
}
};
*/
class SpaceParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , 1 , parse_space )
	parse_map_edge( 1 , 1 , parse_space )
	parse_map_edge( 1 , end_node_id , parse_s_to_e )
	parse_map_end()
	
// parser edge functions
private:
bool parse_space
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	wchar_t	ch = str[*pos];
	if( ch == L' '
	||  ch == L'\n'
	||  ch == L'\r'
	||  ch == L'\t' )
	{
		*pos += 1;
		return true;
	}
	return false;
}
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	return true;
}
};
/**************************************************************************************************
"SkipSpaceParser" class 
**************************************************************************************************/
/*
class SkipSpaceParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	wstring		m_value;
	
// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	return MatchString( str , pos , L"[ \\n\\r\\t]*" , &m_value );
}
};
*/
class SkipSpaceParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , start_node_id , parse_ss )
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	
// parser edge functions
private:
bool parse_ss
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	wchar_t	ch = str[*pos];
	if( ch == L' '
	||  ch == L'\n'
	||  ch == L'\r'
	||  ch == L'\t' )
	{
		*pos += 1;
		return true;
	}
	return false;
}
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	return true;
}
};
/**************************************************************************************************
"IdentParser" class 
**************************************************************************************************/
class IdentParser : public Parser
{
	parse_map_start()
	parse_map_edge( start_node_id , end_node_id , parse_s_to_e )
	parse_map_end()
	
// variable member
public:
	wstring		m_value;

// parser edge functions
private:
bool parse_s_to_e
		(
		const wstring&	str , 
		int*			pos , 
		int*			errpos
		)
{
	return MatchString( str , pos , L"[_A-Za-z]+[_A-Za-z0-9]*" , &m_value );
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
