/*************************************************************************************************/
/*!
   	@file		iSurface.h
	@author 	Fanzo
 	@date 		2008/3/4
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files


#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne
#define		cb_pixelsize( a )	( ( a == rgb_pixelformat ) ? 4 : ( ( a == argb_pixelformat ) ? 4 : 8 ) )

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

enum pixelformat
{
	rgb_pixelformat		= 0 ,		// X , R , G , B
	rgba_pixelformat	= 1 ,		// A , R , G , B
	a_pixelformat		= 2 ,		// A	this format buffer size need to be multiple of four.
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

#pragma pack( push , 1 )		//set align
struct rgb_pixel
{
	uint8	padding , r , g , b;
};
struct rgba_pixel
{
	uint8	a , r , g , b;
};
struct	a_pixel
{
	uint8	a;
};
struct pixel
{
	union
	{
		rgb_pixel		rgb;
		rgba_pixel		rgba;
		a_pixel			a;
	};
};
#pragma pack( pop )			//release align

/**************************************************************************************************
 "ISurfaceDest" interface 
***************************************************************************************************/
cb_guid_define( ISurfaceDest_IID , 0xD15CCB5F , 0x1A9F438c , 0xB83F720A , 0x910E4E61 );
class ISurfaceDest;
typedef icubic::iface_object< ISurfaceDest , ISurfaceDest_IID >		iSurfaceDest;
typedef icubic::iface_reference< ISurfaceDest , ISurfaceDest_IID >	rSurfaceDest;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISurfaceDest
{
public:
//=================================================================================================
//!	get dest dpi
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
DPI cb_call GetDestDPI()const = 0;
//=================================================================================================
//!	get dest size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetDestSize()const = 0;
//=================================================================================================
//!	get available area
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
irect cb_call GetDestAvailableArea()const = 0;
//=================================================================================================
//!	get format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
pixelformat cb_call GetDestFormat()const = 0;
//=================================================================================================
//!	get pixel pointer
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void* cb_call GetDestPixelPtr
		(
		int		*pitchbyte
		)const = 0;
#ifdef cb_windows		
//=================================================================================================
//!	get hdc
//!	@retval			if not win surface , return NULL
//-------------------------------------------------------------------------------------------------
virtual
HDC cb_call GetDestHDC
		(
		irect*		view		= 0 , 
		irect*		available	= 0
		) = 0;
#endif
};
/**************************************************************************************************
 "ISurfaceSource" interface 
***************************************************************************************************/
cb_guid_define( ISurfaceSource_IID , 0xAB137FBB , 0xD0764602 , 0x8CE588FD , 0xC2D9486A );
class ISurfaceSource;
typedef icubic::iface_object< ISurfaceSource , ISurfaceSource_IID >		iSurfaceSource;
typedef icubic::iface_reference< ISurfaceSource , ISurfaceSource_IID >	rSurfaceSource;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISurfaceSource
{
public:
//=================================================================================================
//!	get source dpi
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
DPI cb_call GetSourceDPI()const = 0;
//=================================================================================================
//!	get source area
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
irect cb_call GetSourceAvailableArea()const = 0;
//=================================================================================================
//!	get available area
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetSourceSize()const = 0;
//=================================================================================================
//!	get format
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
pixelformat cb_call GetSourceFormat()const = 0;
//=================================================================================================
//!	get pixel pointer
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
const void* cb_call GetSourcePixelPtr
		(
		int		*pitchbyte
		)const = 0;
#ifdef cb_windows		
//=================================================================================================
//!	get hdc
//!	@retval			if not win surface , return NULL
//-------------------------------------------------------------------------------------------------
virtual
HDC cb_call GetSourceHDC
		(
		irect*		view		= 0 , 
		irect*		available	= 0
		) = 0;
#endif
};
/**************************************************************************************************
 "ISurface" interface 
***************************************************************************************************/
cb_guid_define( ISurface_IID , 0xE838B5BA , 0xC3174f87 , 0x96B9162B , 0xA8C3B923 );
class ISurface;
typedef icubic::iface_object< ISurface , ISurface_IID >		iSurface;
typedef icubic::iface_reference< ISurface , ISurface_IID >	rSurface;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISurface : 
		public ISurfaceDest , 
		public ISurfaceSource
{
public:
//=================================================================================================
//!	set dpi
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
DPI cb_call GetDPI()const = 0;
//=================================================================================================
//!	get surface size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetSurfaceSize()const = 0;
#ifdef cb_windows
//=================================================================================================
//!	get hdc
//!	@retval			if not win surface , return NULL
//-------------------------------------------------------------------------------------------------
virtual
HDC cb_call GetSurfaceHDC() = 0;
#endif
};
/**************************************************************************************************
 "ISurfaceViewport" interface 
***************************************************************************************************/
cb_guid_define( ISurfaceViewport_IID , 0xA6708A9D , 0x64C444eb , 0x84A73E23 , 0xDE8B8D57 );
class ISurfaceViewport;
typedef icubic::iface_object< ISurfaceViewport , ISurfaceViewport_IID >		iSurfaceViewport;
typedef icubic::iface_reference< ISurfaceViewport , ISurfaceViewport_IID >	rSurfaceViewport;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISurfaceViewport : public ISurface

{
public:
//=================================================================================================
//!	set viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetViewport
		(
		const irect&	rect
		) = 0;
//=================================================================================================
//!	release viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseViewport() = 0;
//=================================================================================================
//!	get viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
irect cb_call GetViewport() = 0;
//=================================================================================================
//!	set dest update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetClip
		(
		const irect&	rect		//!< [in]  this is viewport coordinate
		) = 0;
//=================================================================================================
//!	release dest update
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseClip() = 0;
//=================================================================================================
//!	get world size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetViewportMax() = 0;
};

/**************************************************************************************************
 "ISurfaceDestViewport" interface 
***************************************************************************************************/
cb_guid_define( ISurfaceDestViewport_IID , 0xE33A235E , 0xC52847a5 , 0xA3A9D7DC , 0x44A8BA28 );
class ISurfaceDestViewport;
typedef icubic::iface_object< ISurfaceDestViewport , ISurfaceDestViewport_IID >		iSurfaceDestViewport;
typedef icubic::iface_reference< ISurfaceDestViewport , ISurfaceDestViewport_IID >	rSurfaceDestViewport;
///////////////////////////////////////////////////////////////////////////////////////////////////
class ISurfaceDestViewport : public ISurfaceDest
{
public:
//=================================================================================================
//!	set viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetViewport
		(
		const irect&	rect
		) = 0;
//=================================================================================================
//!	set viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseViewport() = 0;
//=================================================================================================
//!	get viewport
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
irect cb_call GetViewport() = 0;
//=================================================================================================
//!	set clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call SetClip
		(
		const irect&	rect		//!< [in]  this is viewport coordinate
		) = 0;
//=================================================================================================
//!	release clip
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
void cb_call ReleaseClip() = 0;
//=================================================================================================
//!	get surface size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
virtual
isize cb_call GetViewportMax() = 0;
};



///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

//=================================================================================================
//!	get pixel size
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
int get_pixel_byte
		(
		pixelformat		format
		)
{
	static
	int		size_tbl[] = 
	{ 
		sizeof( rgb_pixel ) ,
		sizeof( rgba_pixel ) ,
		sizeof( a_pixel ) ,
	};
	return size_tbl[ format ];
}
//=================================================================================================
//!	rgba to pixel
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void to_pixel
		(
		pixelformat		format , 
		void*			dest , 
		const rgba&		color
		)
{	
	if( format == rgb_pixelformat )
	{
		rgb_pixel	*p	= (rgb_pixel*)dest;
		p->r	= ( ( uint32 )color.r * ( uint32 )color.a ) / 255;
		p->g	= ( ( uint32 )color.g * ( uint32 )color.a ) / 255;
		p->b	= ( ( uint32 )color.b * ( uint32 )color.a ) / 255;
		return;
	}
	else if( format == rgba_pixelformat )
	{
		rgba_pixel	*p	= (rgba_pixel*)dest;
		p->a	= color.a;
		p->r	= ( ( uint32 )color.r * ( uint32 )color.a ) / 255;
		p->g	= ( ( uint32 )color.g * ( uint32 )color.a ) / 255;
		p->b	= ( ( uint32 )color.b * ( uint32 )color.a ) / 255;
		return;
	}
	else if( format == a_pixelformat )
	{
		a_pixel	*p	= (a_pixel*)dest;
		p->a	= color.a;
	}
	cb_assert( false , L"invalid format." );
}
//=================================================================================================
//!	rgb to pixel
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void to_pixel
		(
		pixelformat		format , 
		void*			dest , 
		const rgb&		color
		)
{	
	if( format == rgb_pixelformat )
	{
		rgb_pixel	*p	= (rgb_pixel*)dest;
		p->r	= color.r;
		p->g	= color.g;
		p->b	= color.b;
		return;
	}
	else if( format == rgba_pixelformat )
	{
		rgba_pixel	*p	= (rgba_pixel*)dest;
		p->a	= 255;
		p->r	= color.r;
		p->g	= color.g;
		p->b	= color.b;
		return;
	}
	else if( format == a_pixelformat )
	{
		a_pixel	*p	= (a_pixel*)dest;
		p->a	= 255;
	}
	cb_assert( false , L"invalid format." );
}
//=================================================================================================
//!	alpha_a to pixel
//!	@retval			---
//-------------------------------------------------------------------------------------------------
cb_inline
void to_pixel
		(
		pixelformat		format , 
		void*			dest , 
		const rgb&		color , 
		uint8			alpha
		)
{	
	if( format == rgb_pixelformat )
	{
		rgb_pixel	*p	= (rgb_pixel*)dest;
		p->r	= ( uint32 )color.r * ( uint32 )alpha / 255;
		p->g	= ( uint32 )color.g * ( uint32 )alpha / 255;
		p->b	= ( uint32 )color.b * ( uint32 )alpha / 255;
		return;
	}
	else if( format == rgba_pixelformat )
	{
		rgba_pixel	*p	= (rgba_pixel*)dest;
		p->a	= alpha;
		p->r	= ( uint32 )color.r * ( uint32 )alpha / 255;
		p->g	= ( uint32 )color.g * ( uint32 )alpha / 255;
		p->b	= ( uint32 )color.b * ( uint32 )alpha / 255;
		return;
	}
	else if( format == a_pixelformat )
	{
		a_pixel	*p	= (a_pixel*)dest;
		p->a	= alpha;
	}
	cb_assert( false , L"invalid format." );
}

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
