/*************************************************************************************************/
/*!
   	@file		TextureSolidColorColor.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TextureSolidColor" class 
**************************************************************************************************/
class TextureSolidColor : 
	public ITextureSolidColor , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( ITexture , ITexture_IID )
	iface_hook( ITextureSolidColor , ITextureSolidColor_IID )
	query_end( object_base )
	
// variable member
private:
	rgba		m_color;
		
// private functions
private:

public:

// "ITexture" interface functions
//=================================================================================================
isize cb_call TextureSize()
{
	return isize( 1 , 1 );
}
//=================================================================================================
DPI cb_call TextureDPI()
{
	return DPI();
}
//=================================================================================================
ITexture::Type cb_call TextureType()
{
	return ITexture::Color;
}
//=================================================================================================
rgba cb_call TextureColor()
{
	return m_color;
}
//=================================================================================================
pixelformat	cb_call TextureImageFormat()
{
	return rgba_pixelformat;
}
//=================================================================================================
bool cb_call BeginTextureImage()
{
	return false;
}
//=================================================================================================
void cb_call TextureImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
}
//=================================================================================================
void cb_call EndTextureImage()
{
}
// "ITextureSolidColor" interface functions
public:
//=================================================================================================
void cb_call SetColor
		(
		const rgba&	color
		)
{
	m_color	= color;
}
//=================================================================================================
rgba cb_call GetColor()
{
	return m_color;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
TextureSolidColor()
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
