/*************************************************************************************************/
/*!
   	@file		TextureImageNearest.h
	@author 	Fanzo
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iTexture.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"TextureImageNearest" class 
**************************************************************************************************/
class TextureImageNearest : 
	public ITextureImage , 
	virtual public object_base
{
// query
	query_begin()
	iface_hook( ITexture , ITexture_IID )
	iface_hook( ITextureImage , ITextureImage_IID )
	query_end( object_base )
	
// variable member
private:
	faffine			m_transform;
	iSurfaceSource	m_texture;
	Wraptype		m_wraptype;
		
// "ITexture" interface functions
public:
//=================================================================================================
isize cb_call TextureSize()
{
	return m_texture->GetSourceSize();
}
//=================================================================================================
DPI cb_call TextureDPI()
{
	return m_texture->GetSourceDPI();
}
//=================================================================================================
ITexture::Type cb_call TextureType()
{
	return ITexture::Image;
}
//=================================================================================================
rgba cb_call TextureColor()
{
	return rgba();
}
//=================================================================================================
pixelformat	cb_call TextureImageFormat()
{
	return m_texture->GetSourceFormat();
}
//=================================================================================================
bool cb_call BeginTextureImage()
{
	if( m_texture == false )
		return false;
	isize size	= m_texture->GetSourceSize();
	if( size.width == 0 || size.height == 0 )
		return false;
	return true;
}
//=================================================================================================
void cb_call TextureImage
		(
		void				*image , 
		int					len , 
		const fvector2&		suv , 
		const fvector2&		tuv
		)
{
	fvector2	tsuv	= m_transform.Transform( suv );
	fvector2	ttuv	= m_transform.Transform( tuv );
	int			pitchbyte;
	const void	*p = m_texture->GetSourcePixelPtr( &pitchbyte );
	pp_texture_nearest_m
			(
			to_pp_format( m_texture->GetSourceFormat() ) , 
			image , 
			len , 
			tsuv.x , 
			tsuv.y , 
			ttuv.x , 
			ttuv.y , 
			to_pp_format( m_texture->GetSourceFormat() ) , 
			p , 
			pitchbyte , 
			m_texture->GetSourceSize().width , 
			m_texture->GetSourceSize().height , 
			to_pp_color( rgba() ) , 
			to_pp_alpha( 255 ) , 
			to_pp_wraptype( m_wraptype )
			);
}
//=================================================================================================
void cb_call EndTextureImage()
{
}
// "ITextureImage" interface functions
//=================================================================================================
void cb_call SetTransform
		(
		const faffine&	trans
		)
{
	m_transform	= trans;
}
//=================================================================================================
faffine cb_call GetTransform()
{
	return m_transform;
}
//=================================================================================================
void cb_call SetWraptype
		(
		Wraptype	wrap
		)
{
	m_wraptype	= wrap;
}
//=================================================================================================
Wraptype cb_call GetWraptype()
{
	return m_wraptype;
}
//=================================================================================================
void cb_call SetTexture
		(
		iSurfaceSource&	texture
		)
{
	m_texture	= texture;
}
//=================================================================================================
void cb_call ReleaseTexture()
{
	m_texture.release();
}
//=================================================================================================
iSurfaceSource cb_call GetTexture()
{
	return m_texture;
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
TextureImageNearest() : m_wraptype( Repeat_Wraptype )
{
}
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
