/*************************************************************************************************/
/*!
   	@file		OutlineGenPaint.h
	@author 	Fanzo
 	@date 		2008/3/2
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iOutlineGen.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"OutlineGenPaint_bs" class 
**************************************************************************************************/
template<class t_interface>
class OutlineGenPaint_bs : 
	public t_interface
{
// variable member
private:
	PathSegmentSamplerPaint		m_sampler;

	// work
	OutlineNodePtr*				m_node;
	iOutline					m_outline;
	float						m_samplescale;
	
// "IOutlineGen" interface functions
public:
//=================================================================================================
//!	set samplescale
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call SetSampleScale
		(
		float		samplescale
		)
{
	m_samplescale	= samplescale;
}
//=================================================================================================
//!	begin
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call BeginOutline
		(
		iOutline	&outline , 
		bool		close
		)
{
	cb_assert( m_outline == false , L"Begin called before End." );
	m_outline		= outline;
	OutlineSeg*	outlineinfo	= m_outline->CreateOutline();
	m_node		= &outlineinfo->m_node;
}
//=================================================================================================
//!	gen outline
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call GenerateOutline
		(
		IPathSegment*	ps
		)
{
	cb_assert( m_outline == true , L"Generate called before Begin." );
	if( ps->IsExist() == false )
		return;
	m_node = m_sampler.Sampling( m_outline , m_node , ps , 0.0f , 1.0f , m_samplescale );
}
//=================================================================================================
//!	end
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void cb_call EndOutline()
{
	cb_assert( m_outline == true , L"End called before Begin." );
	m_outline.release();
}

// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
OutlineGenPaint_bs() : 
		m_node( 0 ) , 
		m_samplescale( 1.0f )
{
}
};
/**************************************************************************************************
"OutlineGenPaint" class 
**************************************************************************************************/
class OutlineGenPaint : 
	public OutlineGenPaint_bs<IOutlineGen> , 
	virtual public object_base
{
// query
	query_begin();
	iface_hook( IOutlineGen , IOutlineGen_IID )
	query_end( object_base );
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
