/*************************************************************************************************/
/*!
   	@file		NormTable.h
	@author 	Fanzo
 	@date 		2008/4/9
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	"iFace/iNormTable.h"

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"NormTable_f" class 
**************************************************************************************************/
class NormTable_f : 
	virtual public object_base ,
	public  INormTable_f
{
// query
	query_begin();
	iface_hook( INormTable_f , INormTable_f_IID )
	query_end( object_base );
	
// variable member
private:
	Array< float >			m_table;
	
// private functions
private:
// "INormTable" interface functions
public:
//=================================================================================================
//!	get color blend table. 256 table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const float* cb_call GetNormTable()
{
	cb_assert( m_table.GetDatanum() == 257 , L"table error." );
	return m_table.GetConstPtr();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTable_f()
{
}
//=================================================================================================
//!	set normalized parameter
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call SetNormFunction
		(
		iNormFunction&		param , 
		float				st , 
		float				tt
		)
{
	if( param == false )
		return false;
	if( m_table.GetDatanum() != 257 )
		m_table.Resize( 257 );

	int		off;
	for( off = 0 ; off < 257 ; off++ )
	{
		m_table[ off ]	= param->GetNormalizedValue( ( tt - st ) * off / 256.0f + st );
	}
	return true;
}
};
/**************************************************************************************************
"NormTable_i16" class 
**************************************************************************************************/
class NormTable_i16 : 
	virtual public object_base , 
	public  INormTable_i16
{
// query
	query_begin();
	iface_hook( INormTable_i16 , INormTable_i16_IID )
	query_end( object_base );
	
// variable member
private:
	Array< int16 >			m_table;
	
// "INormTable" interface functions
public:
//=================================================================================================
//!	get color blend table. 256 table
//!	@retval			---
//-------------------------------------------------------------------------------------------------
const int16* cb_call GetNormTable()
{
	cb_assert( m_table.GetDatanum() == 257 , L"table error." );
	return m_table.GetConstPtr();
}
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
NormTable_i16()
{
}
//=================================================================================================
//!	set normalized parameter
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool cb_call SetNormFunction
		(
		iNormFunction&		param , 
		float				st , 
		float				tt
		)
{
	if( param == false )
		return false;
	if( m_table.GetDatanum() != 257 )
		m_table.Resize( 257 );

	int		off;
	for( off = 0 ; off < 257 ; off++ )
	{	
		m_table[ off ]	= ( int16 )floorf( fabs( param->GetNormalizedValue( ( tt - st ) * off / 256.0f + st ) * 256.0f ) + 0.5f );
	}
	return true;
}
};
///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
