/*************************************************************************************************/
/*!
   	@file		icubiccore.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files

#ifdef WIN32
	#include	<windows.h>
#elif defined( __APPLE__ ) || defined( __linux__ )
	#include	<pthread.h>
#endif

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

//=================================================================================================
// os define
#ifdef	__APPLE__
	#define		cb_mac
#elif	__linux__
	#define		cb_linux
#elif	_WIN32
	#define		cb_windows
#else
	#error	unknown os.
#endif

//=================================================================================================
// compiler define
#ifdef	_MSC_VER
	#define		cb_vc
#elif	__GNUC__ 
	#define		cb_gcc
#else
	#error	unknown compiler.
#endif

//=================================================================================================
// endian define
#if defined( cb_windows )
	#define		cb_little_endian
#elif defined( __LITTLE_ENDIAN__ )
	#define		cb_little_endian
#elif defined( __BIG_ENDIAN__ )
	#define		cb_big_endian
#else
	#error		unknown endian.
#endif 

//=================================================================================================
// preprocessor
#define	cb_stringize( value )	L#value
#define	cb_widen2( str )		L ## str
#define	cb_widen( str )			cb_widen2(str)
#define cb_file					cb_widen( __FILE__ )
#define cb_line					__LINE__

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

/**************************************************************************************************
misc define
**************************************************************************************************/
#if defined( cb_mac )
	#define		cb_call			pascal
	#define		cb_extern		extern "C"
	#define		cb_dll_export	__attribute__ ((visibility("default")))		/*extern "C" __declspec(dllexport)*/
	#define		cb_dll_import	extern
//	#define		cb_dll_export	extern "C"
	#define		cb_tls			__thread
	#define		cb_inline		inline
#elif defined( cb_linux )
	#define		cb_call			
	#define		cb_extern		extern "C"
	#define		cb_dll_export	__attribute__ ((visibility("default")))		/*extern "C" __declspec(dllexport)*/
	#define		cb_dll_import	extern
	#define		cb_tls			__thread
	#define		cb_inline		inline
#elif defined( cb_windows )
	#define		cb_call			__cdecl
	#define		cb_extern		extern "C"
	#define		cb_dll_export	extern "C" __declspec(dllexport)
	#define		cb_dll_import	extern "C" __declspec(dllimport)
	#define		cb_tls			__declspec(thread)
	#define		cb_inline		__forceinline
#else
	#error		Unknown OS.
#endif

#if defined( cb_windows )
	#define		cb_align( a )		__declspec( align( a ) )
#elif defined( cb_mac ) || defined( cb_linux )
	#define		cb_align( a )		__attribute__((aligned(16)))
#else
	#error		unknown OS
#endif


/**************************************************************************************************
type define
**************************************************************************************************/
typedef		signed char				int8;
typedef		unsigned char			uint8;
typedef		signed short			int16;
typedef		unsigned short			uint16;
typedef		signed long				int32;
typedef		unsigned long			uint32;
typedef		signed long long		int64;
typedef		unsigned long long		uint64;
typedef		unsigned long			utf32;
typedef		unsigned short			utf16;
typedef		unsigned char			utf8;
//typedef		char					sjis;
//typedef		wchar_t					wchar;


/**************************************************************************************************
function define
**************************************************************************************************/

#ifdef cb_windows
	#define cb_swprintf( buf , ... )	swprintf_s( buf , _countof(buf) , __VA_ARGS__ )
#else
	#define cb_swprintf( buf , ... )	swprintf( buf , __VA_ARGS__ )
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;

#include	"Debug.h"
#include	"Misc.h"
#include	"Unit.h"
#include	"Color.h"
#include	"Guid.h"
#include	"Atomic.h"
#include	"Object.h"
#include	"Matrix.h"

#pragma pack( pop )			//release align
