/*************************************************************************************************/
/*!
   	@file		unit.h
	@author 	Fanzo
 	@date 		2008/2/28
*/
/*************************************************************************************************/
#pragma		once

///////////////////////////////////////////////////////////////////////////////////////////////////
//include files
#include	<math.h>

#pragma pack( push , 8 )		//set align

namespace icubic
{

///////////////////////////////////////////////////////////////////////////////////////////////////
// preprocessor deifne

///////////////////////////////////////////////////////////////////////////////////////////////////
// type define

///////////////////////////////////////////////////////////////////////////////////////////////////
// classes define

/**************************************************************************************************
"t_vector2" class 
**************************************************************************************************/
template<class t_type>
class t_vector2
{
// variable member
public:
	union
	{
		t_type	m[ 2 ];
		struct
		{
			t_type	x , y;
		};
	};
// public functions
public:
//=================================================================================================
t_vector2() : x( 0 ) , y( 0 )
{
}
//=================================================================================================
template<class t_type_s>
t_vector2
		(
		const t_vector2<t_type_s>&	v
		) : x( (t_type)v.x ) , y( (t_type)v.y )
{
}
//=================================================================================================
template<class t_type_s>
t_vector2
		(
		t_type_s		xx , 
		t_type_s		yy
		) : x( (t_type)xx ) , y( (t_type)yy )
{
}
//=================================================================================================
bool operator==
		(
		const t_vector2<t_type>&	obj
		)const
{
	if( x != obj.x || y != obj.y )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const t_vector2<t_type>&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
t_vector2<t_type> operator+
		(
		const t_vector2<t_type>& obj
		)const
{
	return t_vector2<t_type>( x + obj.x , y + obj.y );
}
//=================================================================================================
void operator+=
		(
		const t_vector2<t_type>& obj
		)
{
	x += obj.x;
	y += obj.y;
}
//=================================================================================================
t_vector2<t_type> operator-
		(
		const t_vector2<t_type>& obj
		)const
{
	return t_vector2<t_type>( x-obj.x , y-obj.y );
}
//=================================================================================================
void operator-=
		(
		const t_vector2<t_type>& obj
		)
{
	x -= obj.x;
	y -= obj.y;
}
//=================================================================================================
t_vector2<t_type> operator-()const
{
	return t_vector2<t_type>( -x , -y );
}
//=================================================================================================
t_vector2<t_type> operator*
		(
		const t_vector2<t_type>&	v
		)const
{
	return t_vector2<t_type>( x * v.x , y * v.y );
}
//=================================================================================================
void operator*=
		(
		const t_vector2<t_type>& v
		)
{
	*this = ( *this ) * v;
}
//=================================================================================================
t_vector2<t_type> operator*
		(
		float	v
		)const
{
	return t_vector2<t_type>( x * v , y * v );
}
//=================================================================================================
void operator*=
		(
		t_type	v
		)
{
	x *= v;
	y *= v;
}
//=================================================================================================
t_vector2<t_type> operator/
		(
		const t_vector2<t_type>& v
		)const
{
	return fvector2( x / v.x , y / v.y );
}
//=================================================================================================
void operator/=
		(
		const t_vector2<t_type>& v
		)
{
	*this	= *this / v;
}
//=================================================================================================
t_vector2<t_type> operator/
		(
		t_type		v
		)const
{
	return t_vector2<t_type>( x / v , y / v );
}
//=================================================================================================
void operator/=
		(
		t_type		v
		)
{
	x /= v;
	y /= v;
}
//=================================================================================================
t_type Length()const
{
	cb_assert( false , L"this function not define." );
	return 0;
}
//=================================================================================================
t_vector2<t_type> GetUnit()const
{
	cb_assert( false , L"this function not define." );
	return t_vector2<t_type>();
}
//=================================================================================================
//!	Inner product
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_type Inner
		(
		const t_vector2<t_type>	&dest
		)const
{
	return x * dest.x + y * dest.y;
}
//=================================================================================================
//!	Outer product
//!	@retval			zvec
//-------------------------------------------------------------------------------------------------
t_type Outer
		(
		const t_vector2<t_type>	&dest
		)const
{
	return ( x*dest.y - y*dest.x );
}
//=================================================================================================
//!	get perpendicular.left
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector2<t_type> GetRotate90()const
{
	return t_vector2<t_type>( -y , x );
}
//=================================================================================================
//!	get perpendicular.right
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector2<t_type> GetRotateM90()const
{
	return -get_rotate90();
}
//=================================================================================================
//!	the angle which two vector form.( param base vector is base. )
//!	@retval			angle(radian)
//-------------------------------------------------------------------------------------------------
float GetAngle_f
		(
		const t_vector2<t_type>	&src
		)const
{
	float				sl	= src.Length();
	if( sl == 0.0f )
		return 0.0f;
	float				tl	= Length();
	if( tl == 0.0f )
		return 0.0f;
	t_vector2<float>	su	= src / sl;
	t_vector2<float>	tu	= *this / tl;
	float				rad	= acosf( clip( su.Inner( tu ) , -1.0f , 1.0f ) );

	if( su.Outer( tu ) < 0.0f )
		rad	= -rad;
	return rad;
}
};
/**************************************************************************************************
 vector functions
**************************************************************************************************/
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_type>
t_vector2<t_type> operator*
		(
		t_type				val , 
		t_vector2<t_type>&	vec
		)
{
	return vec * val;
}
/**************************************************************************************************
"ivector2" class 
**************************************************************************************************/
typedef t_vector2<int>		ivector2;
//=================================================================================================
int t_vector2<int>::Length()const
{
	return ( int )sqrtf( ( float )( x * x ) + ( float )( y * y ) );
}
//=================================================================================================
t_vector2<int> t_vector2<int>::GetUnit()const
{
	float	l = sqrtf( ( float )( x * x ) + ( float )( y * y ) );
	if( l == 0.0f )
		return t_vector2( 1 , 0 );
	return t_vector2( ( int )( x / l ) , ( int )( y / l ) );
}
/**************************************************************************************************
"fvector2" class 
**************************************************************************************************/
typedef t_vector2<float>	fvector2;
//=================================================================================================
float t_vector2<float>::Length()const
{
	return sqrtf( x * x + y * y );
}
//=================================================================================================
t_vector2<float> t_vector2<float>::GetUnit()const
{
	float	len = Length();
	if( len == 0.0f )
		return fvector2( 1.0f , 0.0f );
	return fvector2( x / len , y / len );
}
//=================================================================================================
/*
float t_vector2<float>::GetAngle
		(
		const t_vector2<float>	&dest
		)const
{
	t_vector2<float>	su	= GetUnit();
	t_vector2<float>	tu	= dest.GetUnit();
	float				rad	= acosf( su.Inner( tu ) );

	//calc Outer and if Outer of direction Z is minus , invert sign.
	if( su.Outer( tu ) < 0.0f )
		rad	= -rad;
	return rad;
}
*/
/**************************************************************************************************
"t_vector3" class 
**************************************************************************************************/
template<class t_type>
class t_vector3
{
// variable member
public:
	union
	{
		t_type	m[ 3 ];
		struct
		{
			t_type	x , y , z;
		};
	};
// public functions
public:
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
t_vector3() : x( 0 ) , y( 0 ) , z( 0 )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
t_vector3
		(
		t_type		xx , 
		t_type		yy , 
		t_type		zz
		) : x( xx ) , y( yy ) , z( zz )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
template<class t_type_s>
t_vector3
		(
		const t_vector3<t_type_s>&	v
		) : x( (t_type)v.x ) , y( (t_type)v.y ) , z( (t_type)v.z )
{
}
//=================================================================================================
//!	construct
//-------------------------------------------------------------------------------------------------
template<class t_type_s>
t_vector3
		(
		const t_vector2<t_type_s>&	v
		) : x( (t_type)v.x ) , y( (t_type)v.y ) , z( 0 )
{
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator==
		(
		const t_vector3<t_type>&	obj
		)const
{
	if( x != obj.x || y != obj.y || z != obj.z )
		return false;
	return true;
}
//=================================================================================================
//!	compare
//!	@retval			---
//-------------------------------------------------------------------------------------------------
bool operator!=
		(
		const t_vector3<t_type>&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
//!	add
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator+
		(
		const t_vector3<t_type>& obj
		)const
{
	return t_vector3<t_type>( x + obj.x , y + obj.y , z + obj.z );
}
//=================================================================================================
//!	add
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator+=
		(
		const t_vector3<t_type>& obj
		)
{
	x += obj.x;
	y += obj.y;
	z += obj.z;
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator-
		(
		const t_vector3<t_type>& obj
		)const
{
	return t_vector3<t_type>( x-obj.x , y-obj.y , z-obj.z );
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator-=
		(
		const t_vector3<t_type>& obj
		)
{
	x -= obj.x;
	y -= obj.y;
	z -= obj.z;
}
//=================================================================================================
//!	sub
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator-()const
{
	return t_vector3<t_type>( -x , -y , -z );
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator*
		(
		const t_vector3<t_type>&	v
		)const
{
	return t_vector3<t_type>( x * v.x , y * v.y , z * v.z );
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator*=
		(
		const t_vector3<t_type>& v
		)
{
	*this = ( *this ) * v;
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator*
		(
		t_type	v
		)const
{
	return t_vector3<t_type>( x * v , y * v , z * v );
}
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator*=
		(
		t_type v
		)
{
	x *= v;
	y *= v;
	z *= v;
}
//=================================================================================================
//!	div
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator/
		(
		const t_vector3<t_type>& v
		)const
{
	return t_vector3<t_type>( x / v.x , y / v.y , z / v.z );
}
//=================================================================================================
//!	div
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator/=
		(
		const t_vector3<t_type>& v
		)
{
	*this	= *this / v;
}
//=================================================================================================
//!	div
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> operator/
		(
		float v
		)const
{
	return t_vector3<t_type>( x / v , y / v , z / v );
}
//=================================================================================================
//!	div
//!	@retval			---
//-------------------------------------------------------------------------------------------------
void operator/=
		(
		t_type v
		)
{
	x /= v;
	y /= v;
	z /= v;
}
//=================================================================================================
//!	unit vector
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> GetUnit()const
{
	cb_assert( false , L"this function not define." );
	return 	t_vector3<t_type>();
}
//=================================================================================================
//!	length
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_type Length()const
{
	cb_assert( false , L"this function not define." );
	return 0;
}
//=================================================================================================
//!	Inner product
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_type Inner
		(
		const t_vector3<t_type>	&dest
		)const
{
	return x * dest.x + y * dest.y + z * dest.z;
}
//=================================================================================================
//!	Outer product
//!	@retval			---
//-------------------------------------------------------------------------------------------------
t_vector3<t_type> Outer
		(
		const t_vector3<t_type>	&dest
		)const
{
	return t_vector3<t_type>( y*dest.z - z*dest.y , -( x*dest.z - z*dest.x ) , ( x*dest.y - y*dest.x ) );
}
};
/**************************************************************************************************
 t_vector3 function
**************************************************************************************************/
//=================================================================================================
//!	mul
//!	@retval			---
//-------------------------------------------------------------------------------------------------
template<class t_type>
t_vector3<t_type> operator*
		(
		t_type				val , 
		t_vector3<t_type>&	vec
		)
{
	return vec * val;
}
/**************************************************************************************************
"fvector3" class 
**************************************************************************************************/
typedef t_vector3<float>	fvector3;
//=================================================================================================
float t_vector3<float>::Length()const
{
	return sqrtf( x*x + y*y + z*z );
}
//=================================================================================================
t_vector3<float> t_vector3<float>::GetUnit()const
{
	float	len = Length();
	if( len == 0.0f )
		return t_vector3<float>( 1.0f , 0.0f , 0.0f );
	return t_vector3<float>( x / len , y / len , z / len );
}
/**************************************************************************************************
"t_size" class 
**************************************************************************************************/
template<class t_type>
class t_size
{
// variable member
public:
	union
	{
		t_type		m[ 2 ];
		struct
		{
			t_type		width , height;
		};
	};

// public functions
public:
//=================================================================================================
t_size() : width( 0 ) , height( 0 )
{
}
//=================================================================================================
t_size
		(
		t_type		w , 
		t_type		h
		) : width( w ) , height( h )
{
}
//=================================================================================================
template<class t_type_s>
t_size
		(
		const t_size<t_type_s>&	v
		) : width( (t_type)v.width ) , height( (t_type)v.height )
{
}
//=================================================================================================
bool operator==
		(
		const t_size<t_type>&	obj
		)const
{
	if( width != obj.width )
		return false;
	if( height != obj.height )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const t_size<t_type>&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
t_size<t_type> operator+
		(
		t_type	v
		)const
{
	t_size<t_type>	r( *this );
	r += v;
	return r;
}
//=================================================================================================
void operator+=
		(
		t_type	v
		)
{
	width	+= v;
	height	+= v;
}
//=================================================================================================
t_size<t_type> operator-
		(
		t_type	v
		)const
{
	t_size<t_type>	r( *this );
	r -= v;
	return r;
}
//=================================================================================================
void operator-=
		(
		t_type	v
		)
{
	width	-= v;
	height	-= v;
}
//=================================================================================================
t_size<t_type> operator*
		(
		t_type	v
		)const
{
	t_size<t_type>	r( *this );
	r *= v;
	return r;
}
//=================================================================================================
void operator*=
		(
		t_type	v
		)
{
	width	*= v;
	height	*= v;
}
//=================================================================================================
t_size<t_type> operator/
		(
		t_type	v
		)const
{
	t_size<t_type>	r( *this );
	r /= v;
	return r;
}
//=================================================================================================
void operator/=
		(
		t_type	v
		)
{
	width	/= v;
	height	/= v;
}
};
/**************************************************************************************************
"isize" class 
**************************************************************************************************/
typedef t_size<int>		isize;
typedef t_size<float>	fsize;


/**************************************************************************************************
"t_rect" class 
**************************************************************************************************/
template<class t_type>
class t_rect
{
// variable member
public:
	union
	{
		t_type		m[ 4 ];
		struct
		{
			t_type	xmin , ymin , xmax , ymax;
		};
	};
	
// public functions
public:
//=================================================================================================
t_rect() : 
	xmin( 0 ) , 
	ymin( 0 ) , 
	xmax( 0 ) , 
	ymax( 0 )
{
}
//=================================================================================================
template<class t_type_s>
t_rect
		(
		const t_rect<t_type_s>&		v
		) : 
		xmin( (t_type)v.xmin ) , 
		ymin( (t_type)v.ymin ) , 
		xmax( (t_type)v.xmax )  ,
		ymax( (t_type)v.ymax )
{
}
//=================================================================================================
t_rect
		(
		t_type	txmin , 
		t_type	tymin , 
		t_type	txmax , 
		t_type	tymax
		) : 
		xmin( txmin ) , 
		ymin( tymin ) , 
		xmax( txmax ) ,
		ymax( tymax )
{
}
//=================================================================================================
template<class t_type_s>
t_rect
		(
		const t_vector2<t_type_s>&	pos , 
		const t_size<t_type_s>&		size
		) : 
		xmin( (t_type)pos.x ) , 
		ymin( (t_type)pos.y ) , 
		xmax( (t_type)(pos.x + size.width) ) , 
		ymax( (t_type)(pos.y + size.height) )
{
}
//=================================================================================================
template<class t_type_s>
t_rect
		(
		const t_size<t_type_s>&	size
		) : 
		xmin( (t_type)0 ) , 
		ymin( (t_type)0 ) , 
		xmax( (t_type)size.width ) , 
		ymax( (t_type)size.height )
{
}
//=================================================================================================
template<class t_type_s>
t_rect
		(
		const t_vector2<t_type_s>&	min , 
		const t_vector2<t_type_s>&	max
		) : 
		xmin( (t_type)min.x ) , 
		ymin( (t_type)min.y ) , 
		xmax( (t_type)max.x ) , 
		ymax( (t_type)max.y )
{
}
//=================================================================================================
bool operator==
		(
		const t_rect<t_type>&	obj
		)const
{
	if( xmin != obj.xmin )
		return false;
	if( ymin != obj.ymin )
		return false;
	if( xmax != obj.xmax )
		return false;
	if( ymax != obj.ymax )
		return false;
	return true;
}
//=================================================================================================
bool operator!=
		(
		const t_rect<t_type>&	obj
		)const
{
	return ( *this == obj ) ? false : true;
}
//=================================================================================================
t_rect<t_type> operator<<
		(
		int		shift
		)
{
	cb_assert( false , L"this function not define." );
	return t_rect<t_type>();
}
//=================================================================================================
void operator<<=
		(
		int		shift
		)
{
	*this	= *this << shift;
}
//=================================================================================================
t_rect<t_type> operator>>
		(
		int		shift
		)
{
	cb_assert( false , L"this function not define." );
	return t_rect<t_type>();
}
//=================================================================================================
void operator>>=
		(
		int		shift
		)
{
	*this	= *this >> shift;
}
//=================================================================================================
t_rect<t_type> operator&
		(
		const t_rect<t_type>&	obj
		)const
{
	return And( obj );
}
//=================================================================================================
void operator&=
		(
		const t_rect<t_type>&		obj
		)
{
	*this	= And( obj );
}
//=================================================================================================
t_rect<t_type> operator|
		(
		const t_rect<t_type>& obj
		)const
{
	return Or( obj );
}
//=================================================================================================
void operator|=
		(
		const t_rect<t_type>& obj
		)
{
	*this	= Or( obj );
}
//=================================================================================================
t_size<t_type> Size()const
{
	return t_size<t_type>( Width() , Height() );
}
//=================================================================================================
t_vector2<t_type> Position()const
{
	return t_vector2<t_type>( xmin , ymin );
}
//=================================================================================================
t_vector2<t_type> Min()const
{
	return t_vector2<t_type>( xmin , ymin );
}
//=================================================================================================
t_vector2<t_type> Max()const
{
	return t_vector2<t_type>( xmax , ymax );
}
//=================================================================================================
t_type Width()const
{
	return ( xmax - xmin ) < 0 ? 0 : ( xmax - xmin );
}
//=================================================================================================
t_type Height()const
{
	return ( ymax - ymin ) < 0 ? 0 : ( ymax - ymin );
}
//=================================================================================================
t_rect<t_type> Move
		(
		const t_vector2<t_type> &mov
		)const
{
	return t_rect<t_type>( xmin + mov.x , ymin + mov.y , xmax + mov.x , ymax + mov.y );
}
//=================================================================================================
bool IsInside
		(
		const t_vector2<t_type>	&pos
		)const
{
	if( pos.x < xmin )
		return false;
	if( pos.x >= xmax )
		return false;
	if( pos.y < ymin )
		return false;
	if( pos.y >= ymax )
		return false;
	return true;
}
//=================================================================================================
t_rect<t_type> And
		(
		const t_rect<t_type> &rect
		)const
{
	t_rect<t_type>	r;
	r.xmin		= max( rect.xmin , xmin );
	r.ymin		= max( rect.ymin , ymin );
	r.xmax		= min( rect.xmax , xmax );
	r.ymax		= min( rect.ymax , ymax );
	if( r.IsExist() == false )
		return t_rect<t_type>();
	return r;
}
//=================================================================================================
t_rect<t_type> Or
		(
		const t_rect<t_type> &rect
		)const
{
	t_rect<t_type>	r;
	r.xmin		= min( rect.xmin , xmin );
	r.ymin		= min( rect.ymin , ymin );
	r.xmax		= max( rect.xmax , xmax );
	r.ymax		= max( rect.ymax , ymax );
	if( r.IsExist() == false )
		return t_rect<t_type>();
	return r;
}
//=================================================================================================
bool IsExist()const
{
	if( xmin >= xmax )
		return false;
	if( ymin >= ymax )
		return false;
	return true;
}
//=================================================================================================
t_rect<t_type> Normalize()const
{
	return t_rect<t_type>( min( xmin , xmax ) , min( ymin , ymax ) , max( xmin , xmax ) , max( ymin , ymax ) );
}
};
/**************************************************************************************************
"irect" class 
**************************************************************************************************/
typedef t_rect<int>		irect;
//=================================================================================================
t_rect<int> t_rect<int>::operator<<
		(
		int		shift
		)
{
	t_rect<int>	r	= *this;
	r.xmin	<<= shift;	
	r.ymin	<<= shift;	
	r.xmax	<<= shift;	
	r.ymax	<<= shift;	
	return r;
}
//=================================================================================================
t_rect<int> t_rect<int>::operator>>
		(
		int		shift
		)
{
	t_rect<int>	r	= *this;
	r.xmin	>>= shift;	
	r.ymin	>>= shift;	
	r.xmax  >>= shift;	
	r.ymax  >>= shift;	
	return r;
}
/**************************************************************************************************
"frect" class 
**************************************************************************************************/
typedef t_rect<float>		frect;
//=================================================================================================
t_rect<float> t_rect<float>::operator<<
		(
		int		shift
		)
{
	if( shift == 0 )
		return *this;
	else if( shift > 0 )
	{
		float	v = ( float )( 1 << shift );
		t_rect<float>	r	= *this;
		r.xmin	*= v;
		r.ymin	*= v;
		r.xmax	*= v;
		r.ymax	*= v;
		return r;
	}
	else
	{
		float	v = ( float )( 1 >> shift );
		t_rect<float>	r	= *this;
		r.xmin	/= v;
		r.ymin	/= v;
		r.xmax	/= v;
		r.ymax	/= v;
		return r;
	}
}
//=================================================================================================
t_rect<float> t_rect<float>::operator>>
		(
		int		shift
		)
{
	if( shift == 0 )
		return *this;
	else if( shift > 0 )
	{
		float	v = ( float )( 1 << shift );
		t_rect<float>	r	= *this;
		r.xmin	/= v;
		r.ymin	/= v;
		r.xmax	/= v;
		r.ymax	/= v;
		return r;
	}
	else
	{
		float	v = ( float )( 1 >> shift );
		t_rect<float>	r	= *this;
		r.xmin	*= v;
		r.ymin	*= v;
		r.xmax	*= v;
		r.ymax	*= v;
		return r;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////
// global variable define

///////////////////////////////////////////////////////////////////////////////////////////////////
// global functions define

};	//namespace

//using namespace icubic;		

#pragma pack( pop )			//release align
