/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.icerya.flow.node;

import java.util.HashMap;
import java.util.Map;
import org.arefgard.icerya.flow.core.UsecaseFlow;
import org.arefgard.icerya.flow.exception.UsecaseFlowException;
import org.arefgard.icerya.flow.node.DecisionNode;
import org.arefgard.icerya.flow.node.IncludeNode;
import org.arefgard.icerya.flow.node.InvokeNode;
import org.arefgard.icerya.flow.node.LoadNode;
import org.arefgard.icerya.flow.node.Node;
import org.arefgard.icerya.flow.node.ReceiveNode;
import org.arefgard.icerya.flow.node.ReplyNode;
import org.arefgard.icerya.flow.node.SyncNode;
import org.arefgard.icerya.flow.node.ThrowNode;
import org.arefgard.icerya.flow.node.TransformNode;
import org.arefgard.icerya.flow.node.WaitNode;
import org.arefgard.icerya.flow.node.WhileNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends Thread {
    private String name;
    private Map<String, Node> nodes = new HashMap<String, Node>();
    private Map<String, Object> inputs = new HashMap<String, Object>();
    private Map<String, Object> outputs = new HashMap<String, Object>();
    private UsecaseFlow parent;
    private String startNode;
    private String endNode;

    public Flow(String name, UsecaseFlow parent) {
        this.name = name;
        this.parent = parent;
    }

    public void addNode(Node node) {
        if (node instanceof ReceiveNode) {
            this.startNode = node.getName();
        }
        this.nodes.put(node.getName(), node);
    }

    public Node getNode(String name) {
        return this.nodes.get(name);
    }

    public Map<String, Node> getNodes() {
        return this.nodes;
    }

    public void addInput(String name, Object obj) throws UsecaseFlowException {
        this.inputs.put(name, obj);
    }

    public void setInputs(Map<String, Object> inputs) throws UsecaseFlowException {
        this.inputs = inputs;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public Object getOutput(String name) throws UsecaseFlowException {
        return this.outputs.get(name);
    }

    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            ThreadGroup threadGroup = this.getThreadGroup();
        }
    }

    public void execute(Map<String, Object> param) throws Exception {
        this.inputs = param;
        this.execute();
    }

    public void execute() throws Exception {
        ReceiveNode start = (ReceiveNode)this.nodes.get(this.startNode);
        String nextTo = start.getNextTo();
        Node node = null;
        while (true) {
            if ((node = this.nodes.get(nextTo)) instanceof InvokeNode) {
                InvokeNode invokeNode = (InvokeNode)node;
                invokeNode.invoke(this.parent.getContainerPath(), this.inputs);
                nextTo = invokeNode.getNextTo();
                continue;
            }
            if (node instanceof DecisionNode) {
                DecisionNode decisionNode = (DecisionNode)node;
                nextTo = decisionNode.decide(this.inputs);
                continue;
            }
            if (node instanceof WaitNode) {
                WaitNode waitNode = (WaitNode)node;
                System.out.println(waitNode.getTime());
                try {
                    waitNode.doWait();
                }
                catch (InterruptedException e) {
                    this.parent.setThrowable(e);
                    if (!this.name.equals("_main")) break;
                    this.parent.setFinished(true);
                    break;
                }
                nextTo = waitNode.getNextTo();
                continue;
            }
            if (node instanceof ThrowNode) {
                ThrowNode throwNode = (ThrowNode)node;
                try {
                    this.parent.setThrowable(throwNode.getThrowable());
                }
                catch (Exception e) {
                    if (!this.name.equals("_main")) break;
                    this.parent.setFinished(true);
                    break;
                }
                if (!this.name.equals("_main")) break;
                this.parent.setFinished(true);
                break;
            }
            if (node instanceof IncludeNode) {
                IncludeNode includeNode = (IncludeNode)node;
                includeNode.call(this.inputs);
                nextTo = includeNode.getNextTo();
                continue;
            }
            if (node instanceof ReplyNode) {
                ReplyNode replyNode = (ReplyNode)node;
                int i = 0;
                int n = replyNode.getPropertySize();
                while (i < n) {
                    this.outputs.put(replyNode.getProperty(i), this.inputs.get(replyNode.getProperty(i)));
                    ++i;
                }
                this.endNode = replyNode.getName();
                if (!this.name.equals("_main")) break;
                this.parent.setFinished(true);
                break;
            }
            if (node instanceof WhileNode) {
                WhileNode whileNode = (WhileNode)node;
                nextTo = whileNode.doWhile(this.inputs);
                continue;
            }
            if (node instanceof SyncNode) {
                SyncNode syncNode = (SyncNode)node;
                nextTo = syncNode.execute();
                continue;
            }
            if (node instanceof LoadNode) {
                LoadNode loadNode = (LoadNode)node;
                loadNode.load(this.parent.getContainerPath(), this.inputs);
                nextTo = loadNode.getNextTo();
                continue;
            }
            if (!(node instanceof TransformNode)) continue;
            TransformNode transformNode = (TransformNode)node;
        }
    }

    public Node getStartNode() {
        return this.nodes.get(this.startNode);
    }

    public Node getEndNode() {
        return this.nodes.get(this.endNode);
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
    }

    public UsecaseFlow getParent() {
        return this.parent;
    }

    public void setParent(UsecaseFlow parent) {
        this.parent = parent;
    }
}

