/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.flow.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.arefgard.flow.exception.UsecaseFlowException;
import org.arefgard.flow.exception.UsecaseFlowExecuteException;
import org.arefgard.flow.integration.DIContainer;
import org.arefgard.flow.integration.DIContainerFactory;
import org.arefgard.flow.node.Node;
import org.arefgard.flow.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeNode
extends Node {
    private String type;
    private String method;
    private String nextTo;
    private List<String> properties = new ArrayList<String>();
    private String returnValue;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getNextTo() {
        return this.nextTo;
    }

    public void setNextTo(String nextTo) {
        this.nextTo = nextTo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addProperty(String name) {
        this.properties.add(name);
    }

    public String getProperty(int index) {
        return this.properties.get(index);
    }

    public String getReturn() {
        return this.returnValue;
    }

    public void setReturn(String returnValue) {
        this.returnValue = returnValue;
    }

    public void invoke(String path, Map<String, Object> params) throws UsecaseFlowException {
        DIContainer container = DIContainerFactory.createContainer(path);
        Object obj = container.get(this.type);
        ArrayList<Object> paramList = new ArrayList<Object>();
        int i = 0;
        int n = this.properties.size();
        while (i < n) {
            paramList.add(params.get(this.properties.get(i)));
            ++i;
        }
        try {
            Object ret = ReflectionUtil.execute(obj, this.method, paramList);
            if (this.returnValue != null) {
                params.put(this.returnValue, ret);
            }
        }
        catch (Exception e) {
            throw new UsecaseFlowExecuteException("", e);
        }
    }
}

