/*
 * Decompiled with CFR 0.152.
 */
package org.arefgard.flow.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.arefgard.flow.core.FlowHandler;
import org.arefgard.flow.core.UsecaseFlow;
import org.arefgard.flow.exception.UsecaseFlowDefinitionParseException;
import org.arefgard.flow.exception.UsecaseFlowException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class UsecaseFlowDefinitionReader {
    private UsecaseFlow flow;

    public UsecaseFlowDefinitionReader(UsecaseFlow flow) {
        this.flow = flow;
    }

    public void parse(String path) throws UsecaseFlowException {
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new UsecaseFlowDefinitionParseException("Creation XMLReader failed.", e);
        }
        reader.setContentHandler(new FlowHandler(this.flow));
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(path);
        }
        try {
            try {
                reader.parse(new InputSource(is));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new UsecaseFlowDefinitionParseException("Usecase flow Definition File Parsing failed.", e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

