/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.HtmlUtils;

public class FormTag
extends AbstractHtmlElementTag {
    private static final String DEFAULT_METHOD = "post";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ONSUBMIT_ATTRIBUTE = "onsubmit";
    public static final String ONRESET_ATTRIBUTE = "onreset";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String ACTION_ATTRIBUTE = "action";
    public static final String ENCTYPE_ATTRIBUTE = "enctype";
    private TagWriter tagWriter;
    private String commandName = "command";
    private String name;
    private String action;
    private String method = "post";
    private String enctype;
    private String onsubmit;
    private String onreset;

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    protected String getCommandName() {
        return this.commandName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAction(String action) {
        this.action = action != null ? action : "";
    }

    protected String getAction() {
        return this.action;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    protected String getMethod() {
        return this.method;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    protected String getEnctype() {
        return this.enctype;
    }

    public void setOnsubmit(String onsubmit) {
        this.onsubmit = onsubmit;
    }

    protected String getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnreset(String onreset) {
        this.onreset = onreset;
    }

    protected String getOnreset() {
        return this.onreset;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.tagWriter = tagWriter;
        this.tagWriter.startTag("form");
        this.writeDefaultAttributes(tagWriter);
        this.tagWriter.writeAttribute(METHOD_ATTRIBUTE, this.getDisplayString(this.evaluate(METHOD_ATTRIBUTE, this.getMethod())));
        this.tagWriter.writeAttribute(ACTION_ATTRIBUTE, this.resolveAction());
        this.writeOptionalAttribute(tagWriter, ENCTYPE_ATTRIBUTE, this.getEnctype());
        this.writeOptionalAttribute(tagWriter, ONSUBMIT_ATTRIBUTE, this.getOnsubmit());
        this.writeOptionalAttribute(tagWriter, ONRESET_ATTRIBUTE, this.getOnreset());
        this.tagWriter.forceBlock();
        this.pageContext.setAttribute(COMMAND_NAME_VARIABLE_NAME, (Object)this.resolveCommandName(), 2);
        return 1;
    }

    protected String getName() throws JspException {
        return this.name;
    }

    protected String autogenerateId() throws JspException {
        return this.resolveCommandName();
    }

    protected String resolveCommandName() throws JspException {
        Object resolvedCommmandName = this.evaluate("commandName", this.getCommandName());
        if (resolvedCommmandName == null) {
            throw new IllegalArgumentException("'commandName' must not be null");
        }
        return (String)resolvedCommmandName;
    }

    protected String resolveAction() throws JspException {
        String action = this.getAction();
        if (StringUtils.hasText(action)) {
            return ObjectUtils.getDisplayString(this.evaluate(ACTION_ATTRIBUTE, action));
        }
        String requestUri = this.getRequestContext().getRequestUri();
        ServletResponse response = this.pageContext.getResponse();
        if (response instanceof HttpServletResponse) {
            requestUri = ((HttpServletResponse)response).encodeURL(requestUri);
            String queryString = this.getRequestContext().getQueryString();
            if (StringUtils.hasText(queryString)) {
                requestUri = requestUri + "?" + HtmlUtils.htmlEscapeQueryStringParameters(queryString);
            }
        }
        if (StringUtils.hasText(requestUri)) {
            return requestUri;
        }
        throw new IllegalArgumentException("Attribute 'action' is required. Attempted to resolve against current request URI but request URI was null.");
    }

    public int doEndTag() throws JspException {
        this.tagWriter.endTag();
        this.pageContext.getRequest().removeAttribute(COMMAND_NAME_VARIABLE_NAME);
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }

    protected String resolveCssClass() throws JspException {
        return ObjectUtils.getDisplayString(this.evaluate("class", this.getCssClass()));
    }

    public void setPath(String path) {
        throw new UnsupportedOperationException("The 'path' attribute is not supported for forms.");
    }

    public void setCssErrorClass(String cssErrorClass) {
        throw new UnsupportedOperationException("The 'cssErrorClass' attribute is not supported for forms.");
    }
}

