/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.EntityManagerPlusOperations;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class ExtendedEntityManagerCreator {
    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, plusOperations, null, false);
    }

    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, plusOperations, exceptionTranslator, false);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, plusOperations, null, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, plusOperations, exceptionTranslator, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf) {
        return ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, null);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf, Map properties) {
        Assert.notNull(emf, "EntityManagerFactory must not be null");
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            EntityManagerFactory nativeEmf = emfInfo.getNativeEntityManagerFactory();
            EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? nativeEmf.createEntityManager(properties) : nativeEmf.createEntityManager();
            JpaDialect jpaDialect = emfInfo.getJpaDialect();
            EntityManagerPlusOperations plusOperations = null;
            if (jpaDialect != null && jpaDialect.supportsEntityManagerPlusOperations()) {
                plusOperations = jpaDialect.getEntityManagerPlusOperations(rawEntityManager);
            }
            return ExtendedEntityManagerCreator.createProxy(rawEntityManager, plusOperations, emfInfo.getJpaDialect(), true);
        }
        EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, true);
    }

    private static EntityManager createProxy(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator, boolean containerManaged) {
        Assert.notNull(rawEntityManager, "EntityManager must not be null");
        Object[] ifcs = ClassUtils.getAllInterfaces(rawEntityManager);
        if (plusOperations != null) {
            ifcs = (Class[])ObjectUtils.addObjectToArray(ifcs, EntityManagerPlusOperations.class);
        }
        return (EntityManager)Proxy.newProxyInstance(ExtendedEntityManagerCreator.class.getClassLoader(), ifcs, (InvocationHandler)new ExtendedEntityManagerInvocationHandler(rawEntityManager, plusOperations, exceptionTranslator, containerManaged));
    }

    private static class ContainerManagedExtendedEntityManagerSynchronization
    extends TransactionSynchronizationAdapter {
        private final EntityManagerHolder entityManagerHolder;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private boolean holderActive = true;

        public ContainerManagedExtendedEntityManagerSynchronization(EntityManagerHolder emHolder, PersistenceExceptionTranslator exceptionTranslator) {
            this.entityManagerHolder = emHolder;
            this.exceptionTranslator = exceptionTranslator;
        }

        public int getOrder() {
            return 901;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerHolder.getEntityManager());
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.entityManagerHolder.getEntityManager(), this.entityManagerHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.entityManagerHolder.getEntityManager());
            this.holderActive = false;
        }

        public void afterCommit() {
            try {
                this.entityManagerHolder.getEntityManager().getTransaction().commit();
            }
            catch (RuntimeException ex) {
                throw this.convertCompletionException(ex);
            }
        }

        public void afterCompletion(int status) {
            this.entityManagerHolder.setSynchronizedWithTransaction(false);
            if (status != 0) {
                try {
                    this.entityManagerHolder.getEntityManager().getTransaction().rollback();
                }
                catch (RuntimeException ex) {
                    throw this.convertCompletionException(ex);
                }
            }
        }

        private RuntimeException convertCompletionException(RuntimeException ex) {
            DataAccessException daex = this.exceptionTranslator != null ? this.exceptionTranslator.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
            return daex != null ? daex : ex;
        }
    }

    private static class ExtendedEntityManagerInvocationHandler
    implements InvocationHandler {
        private static final Log logger = LogFactory.getLog(ExtendedEntityManagerInvocationHandler.class);
        private final EntityManager target;
        private final EntityManagerPlusOperations plusOperations;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private final boolean containerManaged;
        private boolean jta;

        private ExtendedEntityManagerInvocationHandler(EntityManager target, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator, boolean containerManaged) {
            this.target = target;
            this.plusOperations = plusOperations;
            this.exceptionTranslator = exceptionTranslator;
            this.containerManaged = containerManaged;
            this.jta = this.isJtaEntityManager();
        }

        private boolean isJtaEntityManager() {
            try {
                this.target.getTransaction();
                return false;
            }
            catch (IllegalStateException ex) {
                logger.debug((Object)"Cannot access EntityTransaction handle - assuming we're in a JTA environment");
                return true;
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(EntityManagerPlusOperations.class)) {
                return method.invoke((Object)this.plusOperations, args);
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("joinTransaction")) {
                this.doJoinTransaction(true);
                return null;
            }
            if (method.getName().equals("getTransaction")) {
                if (this.containerManaged) {
                    throw new IllegalStateException("Cannot execute getTransaction() on a container-managed EntityManager");
                }
            } else if (method.getName().equals("close")) {
                if (this.containerManaged) {
                    throw new IllegalStateException("Invalid usage: Cannot close a container-managed EntityManager");
                }
            } else if (method.getName().equals("isOpen") && this.containerManaged) {
                return true;
            }
            if (this.containerManaged) {
                this.doJoinTransaction(false);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private void doJoinTransaction(boolean enforce) {
            if (this.jta) {
                try {
                    this.target.joinTransaction();
                    logger.debug((Object)"Joined JTA transaction");
                }
                catch (TransactionRequiredException ex) {
                    if (!enforce) {
                        logger.debug((Object)("No JTA transaction to join: " + (Object)((Object)ex)));
                    }
                    throw ex;
                }
            } else if (TransactionSynchronizationManager.isSynchronizationActive()) {
                if (!TransactionSynchronizationManager.hasResource(this.target)) {
                    this.enlistInCurrentTransaction();
                }
                logger.debug((Object)"Joined local transaction");
            } else if (!enforce) {
                logger.debug((Object)"No local transaction to join");
            } else {
                throw new TransactionRequiredException("No local transaction to join");
            }
        }

        private void enlistInCurrentTransaction() {
            EntityTransaction et = this.target.getTransaction();
            et.begin();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting resource local transaction on application-managed EntityManager [" + this.target + "]"));
            }
            EntityManagerHolder emh = new EntityManagerHolder(this.target);
            ContainerManagedExtendedEntityManagerSynchronization applicationManagedEntityManagerSynchronization = new ContainerManagedExtendedEntityManagerSynchronization(emh, this.exceptionTranslator);
            TransactionSynchronizationManager.bindResource(this.target, applicationManagedEntityManagerSynchronization);
            TransactionSynchronizationManager.registerSynchronization(applicationManagedEntityManagerSynchronization);
        }
    }
}

