/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IORuntimeException;

public abstract class SerializeUtil {
    private static final int BYTE_ARRAY_SIZE = 8192;

    protected SerializeUtil() {
    }

    public static Object serialize(Object o) throws IORuntimeException, ClassNotFoundRuntimeException {
        byte[] binary = SerializeUtil.fromObjectToBinary(o);
        return SerializeUtil.fromBinaryToObject(binary);
    }

    public static byte[] fromObjectToBinary(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static Object fromBinaryToObject(byte[] binary) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binary);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundRuntimeException(ex);
        }
    }
}

