/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.message.MessageFormatter;

public final class Logger {
    private static final Map loggers = new HashMap();
    private static boolean initialized;
    private final Log log;

    public static synchronized Logger getLogger(Class clazz) {
        Logger logger;
        if (!initialized) {
            Logger.initialize();
        }
        if ((logger = (Logger)loggers.get(clazz)) == null) {
            logger = new Logger(clazz);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static synchronized void initialize() {
        initialized = true;
    }

    public static synchronized void dispose() {
        LogFactory.releaseAll();
        loggers.clear();
        initialized = false;
    }

    private Logger(Class clazz) {
        this.log = LogFactory.getLog((Class)clazz);
    }

    public final boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log.debug(message, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.debug(message);
        }
    }

    public final boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log.info(message, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.info(message);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        this.log.warn(message, throwable);
    }

    public final void warn(Object message) {
        this.log.warn(message);
    }

    public final void error(Object message, Throwable throwable) {
        this.log.error(message, throwable);
    }

    public final void error(Object message) {
        this.log.error(message);
    }

    public final void fatal(Object message, Throwable throwable) {
        this.log.fatal(message, throwable);
    }

    public final void fatal(Object message) {
        this.log.fatal(message);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] args) {
        this.log(messageCode, args, null);
    }

    public final void log(String messageCode, Object[] args, Throwable throwable) {
        char messageType = messageCode.charAt(0);
        if (this.isEnabledFor(messageType)) {
            String message = MessageFormatter.getSimpleMessage(messageCode, args);
            switch (messageType) {
                case 'D': {
                    this.log.debug((Object)message, throwable);
                    break;
                }
                case 'I': {
                    this.log.info((Object)message, throwable);
                    break;
                }
                case 'W': {
                    this.log.warn((Object)message, throwable);
                    break;
                }
                case 'E': {
                    this.log.error((Object)message, throwable);
                    break;
                }
                case 'F': {
                    this.log.fatal((Object)message, throwable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(messageType));
                }
            }
        }
    }

    private boolean isEnabledFor(char messageType) {
        switch (messageType) {
            case 'D': {
                return this.log.isDebugEnabled();
            }
            case 'I': {
                return this.log.isInfoEnabled();
            }
            case 'W': {
                return this.log.isWarnEnabled();
            }
            case 'E': {
                return this.log.isErrorEnabled();
            }
            case 'F': {
                return this.log.isFatalEnabled();
            }
        }
        throw new IllegalArgumentException(String.valueOf(messageType));
    }
}

