/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.convention.impl;

import org.seasar.framework.convention.PersistenceConvention;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;

public class PersistenceConventionImpl
implements PersistenceConvention {
    private String ignoreTablePrefix;
    private String idName = "id";
    private String versionName = "version";
    private String insertedName = "inserted";
    private String updatedName = "updated";
    private String deletedName = "deleted";
    private boolean useEntityNameForId = true;
    private boolean useEntityNameForVersion = true;
    private boolean useEntityNameForInserted = true;
    private boolean useEntityNameForUpdated = true;
    private boolean useEntityNameForDeleted = true;
    private boolean noNameConversion = false;

    public String getIgnoreTablePrefix() {
        return this.ignoreTablePrefix;
    }

    public void setIgnoreTablePrefix(String ignoreTablePrefix) {
        this.ignoreTablePrefix = ignoreTablePrefix;
    }

    public boolean isNoNameConversion() {
        return this.noNameConversion;
    }

    public void setNoNameConversion(boolean noNameConversion) {
        this.noNameConversion = noNameConversion;
    }

    public String getDeletedName() {
        return this.deletedName;
    }

    public void setDeletedName(String deletedName) {
        this.deletedName = deletedName;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public String getInsertedName() {
        return this.insertedName;
    }

    public void setInsertedName(String insertedName) {
        this.insertedName = insertedName;
    }

    public String getUpdatedName() {
        return this.updatedName;
    }

    public void setUpdatedName(String updatedName) {
        this.updatedName = updatedName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public boolean isUseEntityNameForDeleted() {
        return this.useEntityNameForDeleted;
    }

    public void setUseEntityNameForDeleted(boolean useEntityNameForDeleted) {
        this.useEntityNameForDeleted = useEntityNameForDeleted;
    }

    public boolean isUseEntityNameForId() {
        return this.useEntityNameForId;
    }

    public void setUseEntityNameForId(boolean useEntityNameForId) {
        this.useEntityNameForId = useEntityNameForId;
    }

    public boolean isUseEntityNameForInserted() {
        return this.useEntityNameForInserted;
    }

    public void setUseEntityNameForInserted(boolean useEntityNameForInserted) {
        this.useEntityNameForInserted = useEntityNameForInserted;
    }

    public boolean isUseEntityNameForUpdated() {
        return this.useEntityNameForUpdated;
    }

    public void setUseEntityNameForUpdated(boolean useEntityNameForUpdated) {
        this.useEntityNameForUpdated = useEntityNameForUpdated;
    }

    public boolean isUseEntityNameForVersion() {
        return this.useEntityNameForVersion;
    }

    public void setUseEntityNameForVersion(boolean useEntityNameForVersion) {
        this.useEntityNameForVersion = useEntityNameForVersion;
    }

    public String fromTableNameToEntityName(String tableName) {
        AssertionUtil.assertNotNull("tableName", tableName);
        if (this.noNameConversion) {
            return tableName;
        }
        return StringUtil.camelize(StringUtil.trimPrefix(tableName, this.ignoreTablePrefix));
    }

    public String fromEntityNameToTableName(String entityName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        if (this.noNameConversion) {
            return entityName;
        }
        String tableName = StringUtil.decamelize(entityName);
        if (this.ignoreTablePrefix != null) {
            tableName = this.ignoreTablePrefix + tableName;
        }
        return tableName;
    }

    public String fromColumnNameToPropertyName(String columnName) {
        AssertionUtil.assertNotNull("columnName", columnName);
        if (this.noNameConversion) {
            return columnName;
        }
        return StringUtil.decapitalize(StringUtil.camelize(columnName));
    }

    public String fromPropertyNameToColumnName(String propertyName) {
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.noNameConversion) {
            return propertyName;
        }
        return StringUtil.decamelize(propertyName);
    }

    public boolean isDeleted(String entityName, String propertyName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.useEntityNameForDeleted) {
            return propertyName.equals(StringUtil.decapitalize(entityName) + StringUtil.capitalize(this.deletedName));
        }
        return propertyName.equals(this.deletedName);
    }

    public boolean isId(String entityName, String propertyName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.useEntityNameForId) {
            return propertyName.equals(StringUtil.decapitalize(entityName) + StringUtil.capitalize(this.idName));
        }
        return propertyName.equals(this.idName);
    }

    public boolean isInserted(String entityName, String propertyName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.useEntityNameForInserted) {
            return propertyName.equals(StringUtil.decapitalize(entityName) + StringUtil.capitalize(this.insertedName));
        }
        return propertyName.equals(this.insertedName);
    }

    public boolean isUpdated(String entityName, String propertyName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.useEntityNameForUpdated) {
            return propertyName.equals(StringUtil.decapitalize(entityName) + StringUtil.capitalize(this.updatedName));
        }
        return propertyName.equals(this.updatedName);
    }

    public boolean isVersion(String entityName, String propertyName) {
        AssertionUtil.assertNotNull("entityName", entityName);
        AssertionUtil.assertNotNull("propertyName", propertyName);
        if (this.useEntityNameForVersion) {
            return propertyName.equals(StringUtil.decapitalize(entityName) + StringUtil.capitalize(this.versionName));
        }
        return propertyName.equals(this.versionName);
    }
}

