/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer.state;

import iax.protocol.frame.Frame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.command.recv.PeerCommandRecvFacade;
import iax.protocol.peer.state.PeerState;
import iax.protocol.peer.state.Registered;
import iax.protocol.peer.state.Unregistered;

public class Waiting
extends PeerState {
    private static Waiting instance;

    private Waiting() {
        instance = this;
    }

    public static Waiting getInstance() {
        if (instance != null) {
            return instance;
        }
        return new Waiting();
    }

    public void handleRecvFrame(Peer peer, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 15: {
                        PeerCommandRecvFacade.regack(peer, protocolControlFrame);
                        if (peer.isProcessingExit()) {
                            peer.setState(Unregistered.getInstance());
                            break;
                        }
                        peer.setState(Registered.getInstance());
                        break;
                    }
                    case 14: {
                        if (peer.isProcessingExit()) {
                            PeerCommandRecvFacade.regauthRel(peer, protocolControlFrame);
                            break;
                        }
                        PeerCommandRecvFacade.regauthReq(peer, protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleRecvFrame(peer, frame);
                        break;
                    }
                }
            } else {
                super.handleRecvFrame(peer, frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Peer peer, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 17: {
                        peer.sendFullFrameAndWaitForRep(protocolControlFrame);
                        break;
                    }
                    case 13: {
                        peer.sendFullFrameAndWaitForRep(protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleSendFrame(peer, frame);
                        break;
                    }
                }
            } else {
                super.handleSendFrame(peer, frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

