/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer.state;

import iax.protocol.frame.ControlFrame;
import iax.protocol.frame.Frame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.command.recv.PeerCommandRecvFacade;
import iax.protocol.peer.state.Unregistered;

public class PeerState {
    public void handleRecvFrame(Peer peer, Frame frame) {
        try {
            if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 4: {
                        PeerCommandRecvFacade.ack(peer, protocolControlFrame);
                        break;
                    }
                    case 5: {
                        PeerCommandRecvFacade.hangup(peer, protocolControlFrame);
                        break;
                    }
                    case 30: {
                        PeerCommandRecvFacade.poke(peer, protocolControlFrame);
                        break;
                    }
                    case 16: {
                        PeerCommandRecvFacade.regrej(peer, protocolControlFrame);
                        peer.setState(Unregistered.getInstance());
                        break;
                    }
                    case 33: {
                        PeerCommandRecvFacade.unsupport(peer, protocolControlFrame);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Peer peer, Frame frame) {
        try {
            if (frame.getType() == 2) {
                ControlFrame controlFrame = (ControlFrame)frame;
                switch (controlFrame.getSubclass()) {
                    case 5: {
                        peer.sendFullFrameAndWaitForAck(controlFrame);
                        break;
                    }
                }
            } else if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 4: {
                        peer.sendFrame(protocolControlFrame);
                        break;
                    }
                    case 7: {
                        peer.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    case 3: {
                        peer.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

