/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer;

import iax.audio.AudioFactory;
import iax.protocol.call.Call;
import iax.protocol.call.command.send.CallCommandSendFacade;
import iax.protocol.connection.Connection;
import iax.protocol.frame.Frame;
import iax.protocol.frame.FullFrame;
import iax.protocol.frame.MiniFrame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.PeerException;
import iax.protocol.peer.PeerListener;
import iax.protocol.peer.command.send.PeerCommandSendFacade;
import iax.protocol.peer.state.PeerState;
import iax.protocol.peer.state.Registered;
import iax.protocol.peer.state.Unregistered;
import iax.protocol.peer.state.Waiting;
import iax.protocol.util.FrameUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class Peer {
    public static final int PEER_SRCCALLNO = 1;
    public static final int REGISTER_REFRESH = 60;
    private final int RETRY_REFRESH = 1;
    private final int RETRY_MAXCOUNT = 5;
    private String userName;
    private String password;
    private String host;
    private Connection connection;
    private HashMap calls;
    private HashMap srcCallNoFromDestCallNo;
    private HashMap srcCallNoFromCalledNumber;
    private HashMap framesWaitingAck;
    private HashMap framesWaitingReply;
    private int newLocalSrcCallNo;
    private PeerListener peerListener;
    private PeerState state;
    private long srcTimestamp;
    private Timer registerTimer;
    private Timer retryTimer;
    private boolean processingExit;
    private int maxCalls;
    private AudioFactory audioFactory;

    public Peer(PeerListener peerListener, String userName, String password, String host, boolean register, int maxCalls, AudioFactory audioFactory) {
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.maxCalls = maxCalls;
        this.audioFactory = audioFactory;
        this.newLocalSrcCallNo = 2;
        this.peerListener = peerListener;
        this.connection = new Connection(this, host);
        this.calls = new HashMap();
        this.srcCallNoFromDestCallNo = new HashMap();
        this.srcCallNoFromCalledNumber = new HashMap();
        this.framesWaitingAck = new HashMap();
        this.framesWaitingReply = new HashMap();
        this.connection.start();
        this.state = Unregistered.getInstance();
        this.processingExit = false;
        this.retryTimer = new Timer();
        TimerTask retryTimerTask = new TimerTask(){

            public void run() {
                Peer.this.retryFramesWaiting();
            }
        };
        this.retryTimer.schedule(retryTimerTask, 1000L, 1000L);
        this.registerTimer = new Timer();
        if (register) {
            TimerTask registerTimerTask = new TimerTask(){

                public void run() {
                    Peer.this.register();
                }
            };
            this.registerTimer.schedule(registerTimerTask, 0L, 60000L);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public PeerState getState() {
        return this.state;
    }

    public long getTimestamp() {
        long now = Calendar.getInstance().getTimeInMillis();
        return now - this.srcTimestamp;
    }

    public boolean isProcessingExit() {
        return this.processingExit;
    }

    public void setState(PeerState state) {
        this.state = state;
        if (state instanceof Registered) {
            this.peerListener.registered();
        } else if (state instanceof Waiting) {
            this.peerListener.waiting();
        } else if (state instanceof Unregistered) {
            this.peerListener.unregistered();
        }
    }

    public synchronized void ackedFrame(long timeStamp) {
        this.framesWaitingAck.remove(timeStamp);
    }

    public synchronized void repliedFrame(int id) {
        this.framesWaitingReply.remove(id);
    }

    public void register() {
        this.srcTimestamp = Calendar.getInstance().getTimeInMillis();
        PeerCommandSendFacade.regreq(this);
    }

    public void exit() {
        this.processingExit = true;
        this.registerTimer.cancel();
        this.retryTimer.cancel();
        PeerCommandSendFacade.regrel(this);
        Iterator iterator = this.calls.values().iterator();
        while (iterator.hasNext()) {
            CallCommandSendFacade.hangup((Call)iterator.next());
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.peerListener.exited();
    }

    public synchronized Call getCall(int localDestCallNo) throws PeerException {
        if (this.srcCallNoFromDestCallNo.containsKey(localDestCallNo)) {
            int localSrcCallNo = (Integer)this.srcCallNoFromDestCallNo.get(localDestCallNo);
            return (Call)this.calls.get(localSrcCallNo);
        }
        throw new PeerException("Not found any call referenced with the localDestCallNo: " + localDestCallNo);
    }

    public synchronized Call getCall(String calledNumber) throws PeerException {
        if (this.srcCallNoFromCalledNumber.containsKey(calledNumber)) {
            int localSrcCallNo = (Integer)this.srcCallNoFromCalledNumber.get(calledNumber);
            return (Call)this.calls.get(localSrcCallNo);
        }
        throw new PeerException("Not found any call referenced with the calledNumber: " + calledNumber);
    }

    public synchronized void handleRecvFrame(byte[] buffer) {
        try {
            Frame frame = FrameUtil.deserialize(buffer);
            if (frame != null) {
                if (frame.getFull()) {
                    FullFrame fullFrame = (FullFrame)frame;
                    int destCallNo = fullFrame.getDestCallNo();
                    if (destCallNo != 0 && destCallNo != 1) {
                        Call call = (Call)this.calls.get(fullFrame.getDestCallNo());
                        if (call != null) {
                            call.handleRecvFrame(fullFrame);
                        } else {
                            PeerCommandSendFacade.inval(this, frame);
                        }
                    } else {
                        this.state.handleRecvFrame(this, frame);
                    }
                } else {
                    int localSrcCallNo = (Integer)this.srcCallNoFromDestCallNo.get(frame.getSrcCallNo());
                    Call call = (Call)this.calls.get(localSrcCallNo);
                    if (call != null) {
                        call.handleRecvFrame((MiniFrame)frame);
                    } else {
                        PeerCommandSendFacade.inval(this, frame);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void handleSendFrame(Frame frame) {
        try {
            int srcCallNo = frame.getSrcCallNo();
            if (srcCallNo != 0 && srcCallNo != 1) {
                Call call = (Call)this.calls.get(frame.getSrcCallNo());
                if (call != null) {
                    call.handleSendFrame(frame);
                } else {
                    PeerCommandSendFacade.inval(this, frame);
                }
            } else {
                this.state.handleSendFrame(this, frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendFrame(Frame frame) {
        try {
            this.connection.send(frame.serialize());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void sendFullFrameAndWaitForAck(FullFrame fullFrame) {
        this.framesWaitingAck.put(fullFrame.getTimestamp(), fullFrame);
        this.sendFrame(fullFrame);
    }

    public synchronized void sendFullFrameAndWaitForRep(FullFrame fullFrame) {
        this.framesWaitingReply.put(fullFrame.getSubclass(), fullFrame);
        this.sendFrame(fullFrame);
    }

    public void answeredCall(Call call) {
        this.peerListener.answered(call.getCalledNumber());
    }

    public void ringingCall(Call call) {
        this.peerListener.playWaitTones(call.getCalledNumber());
    }

    public synchronized void bindCall(Call call) {
        this.srcCallNoFromDestCallNo.put(call.getDestCallNo(), new Integer(call.getSrcCallNo()));
    }

    public synchronized void endCall(Call call) {
        this.peerListener.hungup(call.getCalledNumber());
        int localSrcCallNo = (Integer)this.srcCallNoFromDestCallNo.get(call.getDestCallNo());
        this.calls.remove(call.getSrcCallNo());
        this.srcCallNoFromDestCallNo.remove(call.getDestCallNo());
    }

    public synchronized Call newCall(String calledNumber) throws PeerException {
        if (this.calls.size() <= this.maxCalls) {
            Call newCall = null;
            try {
                newCall = new Call(this, this.newLocalSrcCallNo, this.audioFactory);
                newCall.startCall(calledNumber);
            }
            catch (Exception e) {
                throw new PeerException(e);
            }
            this.calls.put(this.newLocalSrcCallNo, newCall);
            this.srcCallNoFromCalledNumber.put(calledNumber, new Integer(this.newLocalSrcCallNo));
            ++this.newLocalSrcCallNo;
            return newCall;
        }
        throw new PeerException("Reached calls maximun");
    }

    public synchronized void recvCall(ProtocolControlFrame recvCallFrame) throws PeerException {
        if (this.calls.size() < this.maxCalls) {
            String callingName = "";
            String callingNumber = "";
            try {
                callingName = recvCallFrame.getCallingName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                callingNumber = recvCallFrame.getCallingNumber();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Call newCall = null;
            try {
                newCall = new Call(this, this.newLocalSrcCallNo, this.audioFactory);
                newCall.startCall(callingNumber);
            }
            catch (Exception e) {
                throw new PeerException(e);
            }
            this.calls.put(this.newLocalSrcCallNo, newCall);
            this.srcCallNoFromCalledNumber.put(callingNumber, new Integer(this.newLocalSrcCallNo));
            ++this.newLocalSrcCallNo;
            newCall.handleRecvFrame(recvCallFrame);
            this.peerListener.recvCall(callingName, callingNumber);
        } else {
            PeerCommandSendFacade.ack(this, recvCallFrame);
            PeerCommandSendFacade.busy(this, recvCallFrame);
        }
    }

    private synchronized void retryFramesWaiting() {
        try {
            for (FullFrame retryFullFrame : this.framesWaitingAck.values()) {
                retryFullFrame.incRetryCount();
                if (retryFullFrame.getRetryCount() < 5) {
                    this.sendFrame(retryFullFrame);
                    continue;
                }
                throw new PeerException("Reached retries maximun in the peer for full frame of type " + retryFullFrame.getFrameType() + ", subclass " + retryFullFrame.getSubclass());
            }
            for (FullFrame retryFullFrame : this.framesWaitingReply.values()) {
                retryFullFrame.incRetryCount();
                if (retryFullFrame.getRetryCount() < 5) {
                    this.sendFrame(retryFullFrame);
                    continue;
                }
                throw new PeerException("Reached retries maximun in the peer for full frame of type " + retryFullFrame.getFrameType() + ", subclass " + retryFullFrame.getSubclass());
            }
        }
        catch (PeerException e) {
            this.framesWaitingAck.clear();
            this.framesWaitingReply.clear();
            this.setState(Unregistered.getInstance());
            e.printStackTrace();
        }
    }
}

