/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.FrameException;
import iax.protocol.util.ByteBuffer;

public class InfoElement {
    public static final int CALLED_NUMBER = 1;
    public static final int CALLING_NUMBER = 2;
    public static final int CALLING_NAME = 4;
    public static final int CALLED_CONTEXT = 5;
    public static final int USERNAME = 6;
    public static final int PASSWORD = 7;
    public static final int CAPABILITY = 8;
    public static final int FORMAT = 9;
    public static final int LANGUAGE = 10;
    public static final int VERSION = 11;
    public static final int ADSICPE = 12;
    public static final int DNID = 13;
    public static final int AUTHMETHODS = 14;
    public static final int CHALLENGE = 15;
    public static final int MD5_RESULT = 16;
    public static final int RSA_RESULT = 17;
    public static final int APPARENT_ADDR = 18;
    public static final int REFRESH = 19;
    public static final int DPSTATUS = 20;
    public static final int CALLNO = 21;
    public static final int CAUSE = 22;
    public static final int UNKNOWN = 23;
    public static final int MSGCOUNT = 24;
    public static final int AUTOANSWER = 25;
    public static final int MUSICONHOLD = 26;
    public static final int TRANSFER_ID = 27;
    public static final int RDNIS = 28;
    public static final int PROVISIONING = 29;
    public static final int AESPROVISIONING = 30;
    public static final int DATETIME = 31;
    public static final int DEVICETYPE = 32;
    public static final int SERVICEIDENT = 33;
    public static final int FIRMWAREVER = 34;
    public static final int FWBLOCKDESC = 35;
    public static final int FWBLOCKDATA = 36;
    public static final int PROVVER = 37;
    public static final int CALLINGPRES = 38;
    public static final int CALLINGTON = 39;
    public static final int CALLINGTNS = 40;
    public static final int SAMPLINGRATE = 41;
    public static final int CAUSECODE = 42;
    public static final int ENCRYPTION = 43;
    public static final int ENCKEY = 44;
    public static final int CODEC_PREFS = 45;
    public static final int RR_JITTER = 46;
    public static final int RR_LOSS = 47;
    public static final int RR_PKTS = 48;
    public static final int RR_DELAY = 49;
    public static final int RR_DROPPED = 50;
    public static final int RR_OOO = 51;
    public static final int PLAIN_V = 1;
    public static final int MD5_V = 2;
    public static final int MD5_RSA_V = 3;
    public static final int RSA_V = 4;
    public static final int IAXVERSION_V = 2;
    public static final long GSM_V = 2L;
    public static final long ULAW_V = 4L;
    public static final int HEADER_LENGTH = 2;
    public static final int MAX_DATA_LENGTH = 255;
    private int id;
    private int dataLength;
    private byte[] data;

    public InfoElement(int id, int dataLength, byte[] data) {
        this.id = id;
        this.dataLength = dataLength;
        this.data = data;
    }

    public InfoElement(byte[] buffer) throws FrameException {
        ByteBuffer byteBuffer = new ByteBuffer(buffer);
        try {
            this.id = byteBuffer.get8bits();
            this.dataLength = byteBuffer.get8bits();
            this.data = byteBuffer.getByteArray();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public int getID() {
        return this.id;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] serialize() throws FrameException {
        try {
            ByteBuffer byteBuffer = new ByteBuffer(2 + this.data.length);
            byteBuffer.put8bits(this.id);
            byteBuffer.put8bits(this.dataLength);
            byteBuffer.putByteArray(this.data);
            return byteBuffer.getBuffer();
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

