/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.state;

import iax.protocol.call.Call;
import iax.protocol.call.command.recv.CallCommandRecvFacade;
import iax.protocol.call.command.send.CallCommandSendFacade;
import iax.protocol.call.state.CallState;
import iax.protocol.call.state.Up;
import iax.protocol.frame.ControlFrame;
import iax.protocol.frame.Frame;
import iax.protocol.frame.MiniFrame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.frame.VoiceFrame;

public class Linked
extends CallState {
    private static Linked instance;

    private Linked() {
        instance = this;
    }

    public static Linked getInstance() {
        if (instance != null) {
            return instance;
        }
        return new Linked();
    }

    public void handleRecvFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 2) {
                ControlFrame controlFrame = (ControlFrame)frame;
                switch (controlFrame.getSubclass()) {
                    case 4: {
                        CallCommandRecvFacade.answer(call, controlFrame);
                        call.setState(Up.getInstance());
                        break;
                    }
                    case 15: {
                        CallCommandRecvFacade.proceeding(call, controlFrame);
                        break;
                    }
                    case 3: {
                        CallCommandRecvFacade.ringing(call, controlFrame);
                        break;
                    }
                    default: {
                        CallCommandSendFacade.ack(call, controlFrame);
                        break;
                    }
                }
            } else if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 7: {
                        CallCommandRecvFacade.accept(call, protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleRecvFrame(call, frame);
                        break;
                    }
                }
            } else if (frame.getType() == 4) {
                VoiceFrame voiceFrame = (VoiceFrame)frame;
                CallCommandRecvFacade.voiceFullFrame(call, voiceFrame);
            } else if (frame.getType() == 1) {
                MiniFrame miniFrame = (MiniFrame)frame;
                CallCommandRecvFacade.voiceMiniFrame(call, miniFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSendFrame(Call call, Frame frame) {
        try {
            if (frame.getType() == 2) {
                ControlFrame controlFrame = (ControlFrame)frame;
                switch (controlFrame.getSubclass()) {
                    case 4: {
                        call.sendFullFrameAndWaitForAck(controlFrame);
                        call.setState(Up.getInstance());
                        break;
                    }
                    case 5: {
                        call.sendFullFrameAndWaitForAck(controlFrame);
                        break;
                    }
                    case 3: {
                        call.sendFullFrameAndWaitForAck(controlFrame);
                        break;
                    }
                }
            } else if (frame.getType() == 3) {
                ProtocolControlFrame protocolControlFrame = (ProtocolControlFrame)frame;
                switch (protocolControlFrame.getSubclass()) {
                    case 7: {
                        call.sendFullFrameAndWaitForAck(protocolControlFrame);
                        break;
                    }
                    default: {
                        super.handleSendFrame(call, frame);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

