/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.call.command.recv;

import iax.protocol.call.Call;
import iax.protocol.call.command.send.CallCommandSendFacade;
import iax.protocol.frame.ControlFrame;
import iax.protocol.frame.DTMFFrame;
import iax.protocol.frame.MiniFrame;
import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.frame.VoiceFrame;
import iax.protocol.util.FrameUtil;

public class CallCommandRecvFacade {
    private CallCommandRecvFacade() {
    }

    public static void accept(Call call, ProtocolControlFrame acceptFrame) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(acceptFrame.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            call.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        CallCommandSendFacade.ack(call, acceptFrame);
    }

    public static void ack(Call call, ProtocolControlFrame ackFrame) {
        call.ackedFrame(ackFrame.getTimestamp());
    }

    public static void answer(Call call, ControlFrame answerFrame) {
        call.answeredCall();
        CallCommandSendFacade.ack(call, answerFrame);
    }

    public static void authReq(Call call, ProtocolControlFrame authReqFrame) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(authReqFrame.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            call.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        CallCommandSendFacade.authRep(call, authReqFrame);
    }

    public static void hangup(Call call, ProtocolControlFrame hangupFrame) {
        CallCommandSendFacade.ack(call, hangupFrame);
    }

    public static void lagrq(Call call, ProtocolControlFrame lagrqFrame) {
        CallCommandSendFacade.lagrp(call, lagrqFrame);
    }

    public static void newCall(Call call, ProtocolControlFrame recvCallFrame) {
        CallCommandSendFacade.ack(call, recvCallFrame);
        CallCommandSendFacade.ringing(call);
    }

    public static void ping(Call call, ProtocolControlFrame pingFrame) {
        CallCommandSendFacade.pong(call, pingFrame);
    }

    public static void pong(Call call, ProtocolControlFrame pongFrame) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(pongFrame.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            call.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        CallCommandSendFacade.ack(call, pongFrame);
    }

    public static void proceeding(Call call, ControlFrame proceedingFrame) {
        CallCommandSendFacade.ack(call, proceedingFrame);
    }

    public static void reject(Call call, ProtocolControlFrame rejectFrame) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(rejectFrame.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            call.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        CallCommandSendFacade.ack(call, rejectFrame);
    }

    public static void ringing(Call call, ControlFrame ringingFrame) {
        call.ringingCall();
        CallCommandSendFacade.ack(call, ringingFrame);
    }

    public static void unsupport(Call call, ProtocolControlFrame unsupportFrame) {
        CallCommandSendFacade.ack(call, unsupportFrame);
    }

    public static void voiceFullFrame(Call call, VoiceFrame voiceFrame) {
        call.writeAudioIn(voiceFrame.getTimestamp(), voiceFrame.getData(), true);
        CallCommandSendFacade.ack(call, voiceFrame);
    }

    public static void dtmfFullFrame(Call call, DTMFFrame dtmfFrame) {
        if (dtmfFrame.getType() == 5) {
            System.out.println("dtmfFrame.getSubclass:" + dtmfFrame.getSubclass());
            call.setDTMFCode(String.valueOf(Character.toChars(dtmfFrame.getSubclass())));
        }
        CallCommandSendFacade.ack(call, dtmfFrame);
    }

    public static void voiceMiniFrame(Call call, MiniFrame miniFrame) {
        call.writeAudioIn(miniFrame.getTimestamp(), miniFrame.getData(), false);
    }
}

