/*!
  \file
  \brief ̉{

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ViewHistory.h"
#include "CommonResources.h"
#include "GraphDrawer.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputEvent.h"
#include "InputHandler.h"
#include "InputReceiveComponent.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "Delay.h"

using namespace beego;


struct ViewHistory::pImpl {

  class Schedule : public BaseEntity {
    bool is_terminated;
    StateMachine<Schedule>* state_machine;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  class FirstState : public State<Schedule> {
    CommonResources* common_;
    InputEvent input_event_;

    FirstState(CommonResources* common) : common_(common) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      common_->input_receiver->updateInputEvent(input_event_);
      if (InputEvent::isPressed(input_event_, SDLK_RETURN) ||
          input_event_.left_released) {
        type->changeState(ShimonokuViewState::getObject(common_));
      }
    }

    void exit(Schedule* type) {
    }
  };

  class ShimonokuViewState : public State<Schedule> {
    CommonResources* common_;
    InputEvent input_event_;
    GraphDrawer graph_;

    ShimonokuViewState(CommonResources* common)
      : common_(common), graph_(ShimonokuTyping) {
    }

  public:
    static ShimonokuViewState* getObject(CommonResources* common) {
      static ShimonokuViewState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      graph_.drawGraph();
      placeComponents();
    }

    void execute(Schedule* type) {

      common_->input_receiver->updateInputEvent(input_event_);
      if (InputEvent::isReleased(input_event_, SDLK_RETURN) ||
          input_event_.left_released) {
        type->changeState(KimarijiViewState::getObject(common_));
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {

      graph_.placeComponents();
      common_->input_receiver->clear();
    }

    void removeComponents(void) {

      graph_.removeComponents();
      common_->input_receiver->clear();
    }
  };

  class KimarijiViewState : public State<Schedule> {
    CommonResources* common_;
    InputEvent input_event_;
    GraphDrawer graph_;

    KimarijiViewState(CommonResources* common)
      : common_(common), graph_(KimarijiTyping) {
    }

  public:
    static KimarijiViewState* getObject(CommonResources* common) {
      static KimarijiViewState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {

      graph_.drawGraph();
      placeComponents();
    }

    void execute(Schedule* type) {

      common_->input_receiver->updateInputEvent(input_event_);
      if (InputEvent::isReleased(input_event_, SDLK_RETURN) ||
          input_event_.left_released) {
        type->changeState(FirstState::getObject(common_));
      }
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {

      graph_.placeComponents();
      common_->input_receiver->clear();
    }

    void removeComponents(void) {

      graph_.removeComponents();
      common_->input_receiver->clear();
    }
  };

  CommonResources* common;
  Schedule scheduler;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(0, common) {
  }

  void placeComponents(void) {
    // !!!
  }

  void removeComponents(void) {
    ShimonokuViewState::getObject(common)->removeComponents();
    KimarijiViewState::getObject(common)->removeComponents();
  }
};


ViewHistory::ViewHistory(void) : pimpl(new pImpl) {
}


ViewHistory::~ViewHistory(void) {
}


void ViewHistory::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    input.update_all();
    gui->update();

    quit |= pimpl->scheduler.isTerminated();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }

  // eR|[lg̍폜
  pimpl->removeComponents();
}
