#ifndef SOUND_EFFECT_MANAGER_H
#define SOUND_EFFECT_MANAGER_H

/*!
  \file
  \brief ʉ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


namespace beego {
  /*!
    \brief ʉ̊ǗNX
  */
  class SoundEffectManager {
    SoundEffectManager(const SoundEffectManager& rhs);
    SoundEffectManager& operator = (const SoundEffectManager& rhs);

    struct pImpl;
    //const std::auto_ptr<pImpl> pimpl;
    pImpl* pimpl;

  public:
    enum {
      AllChannel = -1,
      InvalidId = 0,
      DefaultFadeOut = 100,
    };
    SoundEffectManager(void);
    ~SoundEffectManager(void);
    bool isInitialized(void);

    bool registerEffect(int effect_id, const char* file_path);
    void unregisterEffect(int effect_id);

    // ʂ̊ݒ
    void updateVolume(size_t percent, int channel_id = AllChannel);

    // ĐJn, Ǘp̍Đ ID Ԃ, ʂw\, tF[hCw
    int play(int effect_id, size_t fade_in_msec = 0, int volume_percent = 100);

    // ID wɂ~AtF[hAEgwAI҂̂
    void stop(int serial_id = AllChannel,
              size_t fade_out_msec = DefaultFadeOut);

    bool nowPlaying(int serial_id = AllChannel);

    // !!! ܂̃\bhÂ

    // !!! Ƀ{[ݒ肷郁\bhƂH
    void setEachVolume(size_t effect_id, size_t percent);

    //void terminate(void);
  };
};

#endif /* !SOUND_EFFECT_MANAGER_H */
