/*!
  \file
  \brief ̋̓͏

  \author Satofumi KAMIMURA

  $Id$

  \todo ȓ͂̂Ƃ́Aȕ̓͌\
*/

#include "ShimonokuInput.h"
#include "DrawsDefinition.h"
#include "ResourceDefinition.h"
#include "CommonResources.h"
#include "AccessSettings.h"
#include "WakaDrawer.h"
#include "WakaData.h"
#include "TypingRecorder.h"
#include "GuiManager.h"
#include "Layer.h"
#include "TextInputComponent.h"
#include "TextProperty.h"
#include "SdlUtils.h"
#include "GetTicks.h"
#include "UtfString.h"
#include "RomanCreator.h"

using namespace beego;


struct ShimonokuInput::pImpl {
  TypingMode typing_mode;
  TypingTextConverter::ConvertType type_;
  CommonResources* common;
  WakaDrawer waka_drawer;
  int input_complete;
  TextProperty text_property;
  boost::shared_ptr<TextInputComponent> text_input;
  TypingTextConverter converter;
  size_t start_ticks;
  size_t waka_index;
  size_t waka_no;
  std::vector<std::vector<Uint16> > judge_text;
  RomanCreator roman_creator;
  std::vector<Uint16> roman_complete_sample[2];

  pImpl(TypingMode mode, TypingTextConverter::ConvertType type)
    : typing_mode(mode), type_(type), common(CommonResources::getObject()),
      waka_drawer(typing_mode), input_complete(0),
      text_property(common->font, "", WakaDrawSize, White, Black, false),
      text_input(new TextInputComponent(InputWidth, InputSize, text_property,
                                        TextOffset,
                                        (InputSize - WakaDrawSize) / 2)),
      converter(type_), start_ticks(0), waka_index(0), waka_no(0) {

    // !!! ȑOɁArecorder ̕ϊ[h蒼ĂKv
    // !!! ̂ŁATypingTextConverter ̕ϊ[h蒼AH
    // !!! ܂́AIvVŕύXƂɍ蒼ׂH
    converter.registerRecorder(common->recorder);

    // !!! Awaka_index o^郁\bhÂH
    // !!! ܂́A\[gꂽL[z󂯓nɂȂ̂ȁH
    // !!! ܂AƂɍl܂傤

    SDL_Rect position;
    set_SdlRect(&position, (640 - InputWidth)/2,
                bottomPosition(text_input, 480) - BottomOffset);
    text_input->setPosition(&position);
    text_input->swapTextConverter(&converter);
  }

  void clearInputState(void) {
    text_input->clear();
    text_input->releaseDecided();
  }

  void createJudgeText(void) {
    judge_text.resize(5);
    for (size_t i = 0; i < 5; ++i) {
      judge_text[i].clear();
      size_t n = ustrlen(KanaWaka[waka_no][i]);

      for (size_t j = 0; j < n; ++j) {
        Uint16 uch = KanaWaka[waka_no][i][j];
        if (uch == 0x3090) {
          // : 0x3090 -> 0x3044
          uch = 0x3044;
        } else if (uch == 0x3091) {
          // : 0x3091 -> 0x3048
          uch = 0x3048;
        }
        judge_text[i].push_back(uch);
      }
      judge_text[i].push_back(0x0);
    }

    // [}͌̍쐬
    for (int i = 0; i < 2; ++i) {
      std::vector<Uint16> roman_sample = judge_text[i + 3];
      if (typing_mode == KimarijiTyping) {
        // ̋͂̂Ƃ́AQ݂̂̓͌ɂ
        roman_sample[2] = 0x0;
      }

      if (type_ == TypingTextConverter::Kana) {
        // "ȓ" ̂ƂB[}ɕϊȂ
        roman_complete_sample[i] = roman_sample;
      } else {
        // "[}" ̂Ƃ
        roman_creator.convert(roman_complete_sample[i], &roman_sample[0]);
      }
    }
  }

  bool createRomanSample(std::vector<Uint16>& roman_sample) {

    // ͂ꂽ[}ϊ
    std::vector<Uint16> inputed_text;
    std::vector<Uint16> inputed_roman;
    if (text_input->getBuffer(inputed_text) > 0) {
      if (type_ == TypingTextConverter::Kana) {
        // "ȓ" ̂ƂBϊȂ inputed_roman ƂĈ
        inputed_roman = inputed_text;

      } else {
        // "[}" ̂Ƃ
        RomanCreator roman_creator;
        roman_creator.convert(inputed_roman, &inputed_text[0]);
      }
    }

    // ̋ʕ菜Ԃ
    // !!! Ƃ肠Aׂō
    size_t complete_n = roman_complete_sample[input_complete].size() - 1;
    size_t input_n = inputed_roman.size();
    size_t n = (complete_n > input_n) ? input_n : complete_n;
    size_t i = 0;
    for (; i < n; ++i) {
      if (inputed_roman[i] != roman_complete_sample[input_complete][i]) {
        break;
      }
    }
    ustrcat(roman_sample, &roman_complete_sample[input_complete][i]);
#if 0
    // !!! fobO\
    for (std::vector<Uint16>::iterator it = roman_sample.begin();
         it != roman_sample.end(); ++it) {
      fprintf(stderr, "%x", *it);
      fprintf(stderr, "[%x], ", roman_complete_sample[input_complete][i]);
    }
    fprintf(stderr, "\n");
#endif

    bool need_bs = true;
    if (((i == 0) && (input_n == 0)) ||
        ((i == complete_n) && (i == input_n)) ||
        ((i + 1) == input_n)) {
      need_bs = false;
    }
    return need_bs;
  }
};


ShimonokuInput::ShimonokuInput(TypingMode mode,
                               TypingTextConverter::ConvertType type)
  : pimpl(new pImpl(mode, type)) {
}


ShimonokuInput::~ShimonokuInput(void) {
}


void ShimonokuInput::setNextWaka(void) {
  ++pimpl->waka_index;
  if (pimpl->waka_index >= 100) {
    pimpl->waka_index = 0;
  }
}


size_t ShimonokuInput::getCurrentWakaNo(void) {
  return pimpl->common->waka_order[pimpl->waka_index];
}


void ShimonokuInput::updateWaka(void) {

  pimpl->waka_no = getCurrentWakaNo();

  // â̔ԍL^
  pimpl->common->recorder->recordWaka(pimpl->waka_no);
  size_t ticks = GetTicks();
  pimpl->start_ticks = ticks;
  pimpl->converter.registerStartTicks(ticks);

  // ̓R|[lg̏
  pimpl->clearInputState();
  pimpl->input_complete = 0;

  // ㉼gp̍̕쐬
  pimpl->createJudgeText();

  // R|[lg̕`
  pimpl->waka_drawer.setWakaIndex(pimpl->waka_no);

  // [}͌̍쐬
  std::vector<Uint16> roman_sample;

  // "ȓ" ̂Ƃɂ́AŕϊO̕n
  // !!!
  pimpl->createRomanSample(roman_sample);
  pimpl->waka_drawer.setInputSample(pimpl->judge_text, roman_sample);

  // R|[lg̔zu
  placeComponents();
}


void ShimonokuInput::drawWaka(void) {

  // ̋A̋̍XV
  pimpl->waka_drawer.draw();
}


void ShimonokuInput::drawInput(void) {

  if (! pimpl->text_input->isChanged()) {
    return;
  }

  // [}͌̍쐬
  std::vector<Uint16> roman_sample;
  bool need_bs = pimpl->createRomanSample(roman_sample);

  bool is_erased = pimpl->text_input->isErased();
  if ((! is_erased) && (need_bs != false)) {
    // ~X̍ĐBneed_bs ̕\̓͂ŁA~X炷B폜L[͗O
    pimpl->common->playEffect(Miss);

  } else if ((! is_erased) && (! pimpl->text_input->empty())) {
    // ^Cv̍ĐB폜L[ȊȌꍇɁAʉ炷
    pimpl->common->playEffect(Type);
  }

  // ͌̍XV
  pimpl->waka_drawer.updateInputSample(pimpl->judge_text,
                                       pimpl->input_complete, roman_sample,
                                       need_bs);

  // ̋^CsÔƂ́A͂m肳ĂȂ΁A肵Ȃ
  if (pimpl->typing_mode == ShimonokuTyping) {
    if (! pimpl->text_input->isDecided()) {
      return;
    }
    size_t ticks = GetTicks() - pimpl->start_ticks;
    pimpl->common->recorder->recordTyping(TypingRecorder::Return, ticks);
  }
  pimpl->text_input->releaseDecided();

  // ͕̔
  std::vector<Uint16> buffer;
  size_t inputed_length = pimpl->text_input->getBuffer(buffer);
  size_t ku_index = 3 + pimpl->input_complete;
  size_t n = ustrlen(KanaWaka[pimpl->waka_no][ku_index]);

  switch (pimpl->typing_mode) {
  case ShimonokuTyping:
    // ͂̔
    if ((inputed_length > 0) && (n == inputed_length) &&
        (! ustrncmp(&pimpl->judge_text[ku_index][0], &buffer[0], n))) {

      size_t ticks = GetTicks() - pimpl->start_ticks;
      pimpl->common->recorder->recordTyping(TypingRecorder::Complete, ticks);

      ++pimpl->input_complete;
      pimpl->clearInputState();
    }
    break;

  case KimarijiTyping:
    // ŏ̂Qœ͔s
    if ((inputed_length >= 2) &&
        (! ustrncmp(&pimpl->judge_text[ku_index][0], &buffer[0], 2))) {
      ++pimpl->input_complete;
      pimpl->clearInputState();
    }
    break;
  }
}


bool ShimonokuInput::isComplete(void) {

  switch (pimpl->typing_mode) {
  case ShimonokuTyping:
    return (pimpl->input_complete >= 2) ? true : false;
    break;

  case KimarijiTyping:
    return (pimpl->input_complete >= 1) ? true : false;
    break;

  default:
    return false;
  }
}


void ShimonokuInput::placeComponents(void) {
  pimpl->common->front_layer->push_front(pimpl->text_input);
}


void ShimonokuInput::removeComponents(void) {
  removeInputComponents();
  pimpl->waka_drawer.removeComponents();
}


void ShimonokuInput::removeInputComponents(void) {
  pimpl->waka_drawer.removeInputComponents();

  pimpl->text_input->clear();
  pimpl->common->front_layer->remove(pimpl->text_input);
}


bool ShimonokuInput::textEmpty(void) {
  return pimpl->text_input->empty();
}
