/*!
  \file
  \brief Ot̕`

  \author Satofumi KAMIMURA

  $Id$

  \todo Pڂ̃f[^͂AOt(_)\悤ɂ
  \todo [̓_A͂ݏoĂ̂Ƃ
*/

#include "GraphDrawer.h"
#include "GraphDrawer_uni.h"
#include "CommonResources.h"
#include "DrawsDefinition.h"
#include "SystemDefinition.h"
#include "AccessSettings.h"
#include "AccessRecordPC.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputReceiveComponent.h"
#include "InputEvent.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "GraphComponent.h"
#include "SdlUtils.h"

using namespace beego;


struct GraphDrawer::pImpl {
  TypingMode typing_mode_;
  CommonResources* common_;
  bool is_decided_;
  InputEvent input_event_;
  TextProperty title_property_;
  Surface title_surface_;
  Component title_label_;
  boost::shared_ptr<GraphComponent> graph_;

  pImpl(TypingMode mode)
    : typing_mode_(mode), common_(CommonResources::getObject()),
      is_decided_(false),
      title_property_(common_->font, GraphDrawer_title,
                      MenuSize, Fore, Back, true),
      title_surface_(new TextSurface(title_property_)),
      title_label_(new LabelComponent(title_surface_)),
      graph_(new GraphComponent) {

    // R|[lg̐
    graph_->setBackgroundColor(White);

    // R|[lg̈ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label_, 640/2), TextOffset);
    title_label_->setPosition(&position);
  }

  void placeComponents(void) {

    // Otp̃R|[lgzu
    common_->front_layer->push_front(title_label_);
    common_->front_layer->push_front(graph_);

    is_decided_ = false;
    common_->input_receiver->clear();
    common_->front_layer->push_front(common_->user_label);
  }

  void removeComponents(void) {

    // OtpR|[lg̍폜
    common_->front_layer->remove(title_label_);
    common_->front_layer->remove(graph_);

    common_->input_receiver->clear();
    common_->front_layer->remove(common_->user_label);
  }

  bool drawGraph(void) {

    // L^̓ǂݏo
    AccessRecordPC pc_record(typing_mode_);
    time_t now = time(NULL);
    std::vector<TypingRecorder::GameSettings> data;
    bool ret = pc_record.load(data, common_->getUserName(),
                              0, now, GraphHistoryMax);
    if (ret == false) {
      return false;
    }

    enum {
      DelayLine = 0,
      MissLine,
      ElapsedLine,
    };
    int index = 0;
    std::vector<Grid<double> > draw_lines[3];
    for (std::vector<TypingRecorder::GameSettings>::iterator it = data.begin();
         it != data.end(); ++it, ++index) {
      Grid<double> point(index, it->score.miss_types);
      draw_lines[MissLine].push_back(point);

      point.y = it->score.delay_msec / 1000.0;
      draw_lines[DelayLine].push_back(point);

      point.y = it->score.elapse_msec / 1000.0;
      draw_lines[ElapsedLine].push_back(point);
    }

    // Otւ̃f[^o^
    graph_->registerLine(draw_lines[MissLine], Red);
    graph_->registerLine(draw_lines[DelayLine], Green);
    if (typing_mode_ == ShimonokuTyping) {
      // ̋^CsO
      graph_->registerLine(draw_lines[ElapsedLine], Blue);
    }

    // Ot쐬
    graph_->create(GraphWidth, GraphHeight, common_->font);

    // ^Cg̕`
    if (typing_mode_ == ShimonokuTyping) {
      // ̋^CsO
      TextProperty shimonoku_property(common_->font, GraphDrawer_shimonoku,
                                      SmallSize, Fore, Back, true);
      graph_->drawTitle(shimonoku_property);

    } else {
      // ܂莚^CsO
      TextProperty kimariji_property(common_->font, GraphDrawer_kimariji,
                                     SmallSize, Fore, Back, true);
      graph_->drawTitle(kimariji_property);
    }

    SDL_Rect position;
    set_SdlRect(&position, centerPosition(graph_, 640/2),
                middlePosition(graph_, (MenuSize + 480) / 2));
    graph_->setPosition(&position);

    return true;
  }
};


GraphDrawer::GraphDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


GraphDrawer::~GraphDrawer(void) {
}


bool GraphDrawer::drawGraph(void) {
  return pimpl->drawGraph();
}


void GraphDrawer::placeComponents(void) {
  pimpl->placeComponents();
}


void GraphDrawer::removeComponents(void) {
  pimpl->removeComponents();
}


bool GraphDrawer::keyPressed(void) {

  pimpl->common_->input_receiver->updateInputEvent(pimpl->input_event_);
  pimpl->is_decided_ |=
    InputEvent::isReleased(pimpl->input_event_, SDLK_RETURN);

  return pimpl->is_decided_;
}
